<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->startSection('title', 'Manage Permissions - ' . $role->name); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-key me-2"></i>Manage Permissions - <?php echo e($role->name); ?>

                    </h5>
                    <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i>Back to Roles
                    </a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('admin.roles.permissions.update', $role)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-1"><?php echo e($role->name); ?></h6>
                                                <p class="text-muted mb-0"><?php echo e($role->description); ?></p>
                                            </div>
                                            <div class="text-end">
                                                <button type="button" class="btn btn-outline-primary btn-sm" id="selectAll">
                                                    <i class="fas fa-check-square me-1"></i>Select All
                                                </button>
                                                <button type="button" class="btn btn-outline-secondary btn-sm" id="deselectAll">
                                                    <i class="fas fa-times-circle me-1"></i>Deselect All
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card mb-4">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h6 class="mb-0"><?php echo e($module); ?> Module</h6>
                                <small class="text-muted"><?php echo e($modulePermissions->count()); ?> permissions</small>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4 mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input permission-checkbox" type="checkbox" 
                                                   name="permissions[]" 
                                                   value="<?php echo e($permission->id); ?>"
                                                   id="perm_<?php echo e($permission->id); ?>"
                                                   <?php echo e($role->hasPermission($permission->slug) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="perm_<?php echo e($permission->id); ?>">
                                                <strong><?php echo e($permission->name); ?></strong>
                                                <?php if($permission->description): ?>
                                                <br>
                                                <small class="text-muted"><?php echo e($permission->description); ?></small>
                                                <?php endif; ?>
                                            </label>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="text-muted" id="selectedCount">0 permissions selected</span>
                                    </div>
                                    <div>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-1"></i>Update Permissions
                                        </button>
                                        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary">
                                            <i class="fas fa-times me-1"></i>Cancel
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const checkboxes = document.querySelectorAll('.permission-checkbox');
        const selectAllBtn = document.getElementById('selectAll');
        const deselectAllBtn = document.getElementById('deselectAll');
        const selectedCount = document.getElementById('selectedCount');

        function updateSelectedCount() {
            const selected = document.querySelectorAll('.permission-checkbox:checked').length;
            selectedCount.textContent = selected + ' permissions selected';
        }

        // Initial count
        updateSelectedCount();

        // Update count on checkbox change
        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', updateSelectedCount);
        });

        // Select all
        selectAllBtn.addEventListener('click', function() {
            checkboxes.forEach(checkbox => {
                checkbox.checked = true;
            });
            updateSelectedCount();
        });

        // Deselect all
        deselectAllBtn.addEventListener('click', function() {
            checkboxes.forEach(checkbox => {
                checkbox.checked = false;
            });
            updateSelectedCount();
        });
    });
</script>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/roles/permissions.blade.php ENDPATH**/ ?>