<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Audit Logs'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i>Audit Logs</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Timestamp</th>
                                    <th>User</th>
                                    <th>Action</th>
                                    <th>Module</th>
                                    <th>Description</th>
                                    <th>IP Address</th>
                                    <th>action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <small class="text-muted"><?php echo e($log->created_at->format('M d, Y')); ?></small><br>
                                        <small><?php echo e($log->created_at->format('H:i:s')); ?></small>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if($log->admin->profile_image): ?>
                                                <img src="<?php echo e(asset($log->admin->profile_image)); ?>" class="rounded-circle me-2" width="30" height="30" alt="Profile">
                                            <?php else: ?>
                                                <div class="rounded-circle bg-secondary me-2 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                                    <i class="fas fa-user text-white" style="font-size: 12px;"></i>
                                                </div>
                                            <?php endif; ?>
                                            <span><?php echo e($log->admin->name); ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <?php
                                            $actionColors = [
                                                'created' => 'success',
                                                'updated' => 'info', 
                                                'deleted' => 'danger',
                                                'login' => 'primary',
                                                'logout' => 'warning'
                                            ];
                                            $color = $actionColors[$log->action] ?? 'secondary';
                                        ?>
                                        <span class="badge bg-<?php echo e($color); ?>"><?php echo e(ucfirst($log->action)); ?></span>
                                    </td>
                                    <td><?php echo e($log->module); ?></td>
                                    <td>
                                        <span title="<?php echo e($log->description); ?>">
                                            <?php echo e(Str::limit($log->description, 50)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo e($log->ip_address); ?></small>
                                    </td>
                                          <td>
                                        <!-- 🔥 SHOW BUTTON -->
                                        <a href="<?php echo e(route('admin.audit-logs.show', $log)); ?>" class="btn btn-sm btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div class="text-muted">
                            Showing <?php echo e($logs->firstItem()); ?> to <?php echo e($logs->lastItem()); ?> of <?php echo e($logs->total()); ?> entries
                        </div>
                        <div>
                            <?php echo e($logs->links()); ?>

                        </div>
                    </div>

                    <?php if($logs->isEmpty()): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                        <h5>No Audit Logs Found</h5>
                        <p class="text-muted">Activity logs will appear here as users perform actions in the system.</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/audit-logs/index.blade.php ENDPATH**/ ?>