<!DOCTYPE html>
<html lang="en">
<head>
 <!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Zinaxi Admin')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
  <style>
    body, html {
      height: 100%;
      background-color: #f5f7fa;
    }
    .login-container {
      height: 100%;
    }
    .login-box {
      background: #ffffff;
      padding: 40px;
      border-radius: 12px;
      box-shadow: 0 0 20px rgba(0,0,0,0.08);
    }
    .logo {
      max-height: 60px;
      margin-bottom: 20px;
    }
    .btn-login {
      background-color: #27ae60;
      color: #fff;
      font-weight: 600;
      border-radius: 8px;
    }
    .btn-login:hover {
      background-color: #219150;
    }
  </style>
</head>
<body>

<div class="container d-flex justify-content-center align-items-center login-container">
  <div class="col-md-6">
    <div class="login-box text-center">
<!--       <img src="<?php echo e(asset('images/logo/ZinaxiT.PNG')); ?>" alt="ZINAXI Logo" class="logo">
 -->      <h2 class="mb-4">Admin Login</h2>
      <form method="POST" action="<?php echo e(route('admin.login')); ?>">
        <?php echo csrf_field(); ?>
        <div class="mb-3 text-start">
          <input type="email" name="email" class="form-control" placeholder="Email" required />
        </div>
        <div class="mb-3 text-start">
          <input type="password" name="password" class="form-control" placeholder="Password" required />
        </div>
        <button type="submit" class="btn btn-login w-100">Login</button>
      </form>
    </div>
  </div>
</div>
</body>
</html>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/login.blade.php ENDPATH**/ ?>