<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Edit Final Shipment - <?php echo e($shipment->shipment_number); ?></h4>
                <a href="<?php echo e(route('admin.shipments.final-shipments.index', $shipment)); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Updates
                </a>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Edit Final Shipment Update</h5>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.shipments.final-shipments.update', [$shipment, $finalShipment])); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="original_quantity" class="form-label">Original Quantity *</label>
                                            <input type="number" name="original_quantity" id="original_quantity" 
                                                   class="form-control" value="<?php echo e(old('original_quantity', $finalShipment->original_quantity)); ?>" 
                                                   min="0" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="adjusted_quantity" class="form-label">Adjusted Quantity *</label>
                                            <input type="number" name="adjusted_quantity" id="adjusted_quantity" 
                                                   class="form-control" value="<?php echo e(old('adjusted_quantity', $finalShipment->adjusted_quantity)); ?>" 
                                                   required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="final_shipment_date" class="form-label">Final Shipment Date *</label>
                                            <input type="date" name="final_shipment_date" id="final_shipment_date" 
                                                   class="form-control" value="<?php echo e(old('final_shipment_date', $finalShipment->final_shipment_date->format('Y-m-d'))); ?>" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="status" class="form-label">Status *</label>
                                            <select name="status" id="status" class="form-select" required>
                                                <option value="pending" <?php echo e($finalShipment->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                                <option value="adjusted" <?php echo e($finalShipment->status == 'adjusted' ? 'selected' : ''); ?>>Adjusted</option>
                                                <option value="completed" <?php echo e($finalShipment->status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="adjustment_reason" class="form-label">Adjustment Reason *</label>
                                    <textarea name="adjustment_reason" id="adjustment_reason" class="form-control" rows="3" required><?php echo e(old('adjustment_reason', $finalShipment->adjustment_reason)); ?></textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="inspection_remarks" class="form-label">Inspection Remarks</label>
                                    <textarea name="inspection_remarks" id="inspection_remarks" class="form-control" rows="3"><?php echo e(old('inspection_remarks', $finalShipment->inspection_remarks)); ?></textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <a href="<?php echo e(route('admin.shipments.final-shipments.index', $shipment)); ?>" class="btn btn-secondary me-2">Cancel</a>
                                    <button type="submit" class="btn btn-primary">Update Final Shipment</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Quantity Preview</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Original Quantity:</strong><br>
                                <span id="original-qty-preview" class="fw-bold"><?php echo e(number_format($finalShipment->original_quantity)); ?></span>
                            </div>
                            <div class="mb-3">
                                <strong>Adjusted Quantity:</strong><br>
                                <span id="adjusted-qty-preview" class="fw-bold"><?php echo e($finalShipment->adjusted_quantity >= 0 ? '+' : ''); ?><?php echo e($finalShipment->adjusted_quantity); ?></span>
                            </div>
                            <div class="mb-3">
                                <strong>Final Quantity:</strong><br>
                                <span id="final-qty-preview" class="fw-bold text-success"><?php echo e(number_format($finalShipment->final_quantity)); ?></span>
                            </div>
                            <div class="mb-3">
                                <strong>Adjustment Type:</strong><br>
                                <span id="adjustment-type-preview" class="badge bg-<?php echo e($finalShipment->adjustment_type == 'positive' ? 'success' : 'danger'); ?>">
                                    <?php echo e($finalShipment->adjustment_type == 'positive' ? 'Increase' : 'Decrease'); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Update Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Created By:</strong><br>
                                <?php echo e($finalShipment->creator->name); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Created At:</strong><br>
                                <?php echo e($finalShipment->created_at->format('M d, Y H:i')); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Last Updated:</strong><br>
                                <?php echo e($finalShipment->updated_at->format('M d, Y H:i')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate final quantity and adjustment type
function calculateFinalQuantity() {
    const original = parseInt(document.getElementById('original_quantity').value) || 0;
    const adjusted = parseInt(document.getElementById('adjusted_quantity').value) || 0;
    const final = original + adjusted;
    
    document.getElementById('adjusted-qty-preview').textContent = adjusted >= 0 ? '+' + adjusted : adjusted;
    document.getElementById('final-qty-preview').textContent = final.toLocaleString();
    
    const adjustmentType = document.getElementById('adjustment-type-preview');
    if (adjusted > 0) {
        adjustmentType.className = 'badge bg-success';
        adjustmentType.textContent = 'Increase';
    } else if (adjusted < 0) {
        adjustmentType.className = 'badge bg-danger';
        adjustmentType.textContent = 'Decrease';
    } else {
        adjustmentType.className = 'badge bg-secondary';
        adjustmentType.textContent = 'No Change';
    }
}

// Event listeners
document.getElementById('original_quantity').addEventListener('input', calculateFinalQuantity);
document.getElementById('adjusted_quantity').addEventListener('input', calculateFinalQuantity);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateFinalQuantity();
});
</script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/final-shipments/edit.blade.php ENDPATH**/ ?>