<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Booking Invoices - <?php echo e($shipment->shipment_number); ?></h4>
                <div>
                    <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Shipment
                    </a>
                    <a href="<?php echo e(route('admin.shipments.booking-invoices.create', $shipment)); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Create Invoice
                    </a>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Booking Invoices</h5>
                </div>
                <div class="card-body">
                    <?php if($invoices->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Invoice No</th>
                                    <th>Invoice Date</th>
                                    <th>Freight Charges</th>
                                    <th>Insurance Charges</th>
                                    <th>Total Charges</th>
                                    <th>Description</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($invoice->invoice_number); ?></td>
                                    <td><?php echo e($invoice->invoice_date->format('M d, Y')); ?></td>
                                    <td>$<?php echo e(number_format($invoice->freight_charges, 2)); ?></td>
                                    <td>$<?php echo e(number_format($invoice->insurance_charges, 2)); ?></td>
                                    <td class="fw-bold text-success">$<?php echo e(number_format($invoice->total_charges, 2)); ?></td>
                                    <td><?php echo e(Str::limit($invoice->charges_description, 50)); ?></td>
                                    <td class="table-actions">
                                        <a href="<?php echo e(route('admin.shipments.booking-invoices.show', [$shipment, $invoice])); ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.shipments.booking-invoices.edit', [$shipment, $invoice])); ?>" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.shipments.booking-invoices.destroy', [$shipment, $invoice])); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="2">Total</th>
                                    <th>$<?php echo e(number_format($invoices->sum('freight_charges'), 2)); ?></th>
                                    <th>$<?php echo e(number_format($invoices->sum('insurance_charges'), 2)); ?></th>
                                    <th>$<?php echo e(number_format($invoices->sum('total_charges'), 2)); ?></th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-file-invoice fa-3x mb-3"></i>
                        <p>No booking invoices created yet.</p>
                        <a href="<?php echo e(route('admin.shipments.booking-invoices.create', $shipment)); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Create First Invoice
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/booking-invoices/index.blade.php ENDPATH**/ ?>