<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Edit Bank Invoice'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.bank-invoices.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Bank Invoice</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.bank-invoices.update', $bankInvoice)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    <?php $__currentLoopData = $buyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $buyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($buyer->id); ?>" <?php echo e($bankInvoice->buyer_id == $buyer->id ? 'selected' : ''); ?>>
                                        <?php echo e($buyer->company_name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['buyer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($order->id); ?>" <?php echo e($bankInvoice->order_confirmation_id == $order->id ? 'selected' : ''); ?>>
                                        <?php echo e($order->order_number); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['order_confirmation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_date" class="form-label">Invoice Date *</label>
                                <input type="date" name="invoice_date" id="invoice_date" 
                                       class="form-control" value="<?php echo e(old('invoice_date', $bankInvoice->invoice_date->format('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['invoice_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" name="due_date" id="due_date" 
                                       class="form-control" value="<?php echo e(old('due_date', $bankInvoice->due_date->format('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Invoice Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="<?php echo e(old('amount', $bankInvoice->amount)); ?>" required>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tax_amount" class="form-label">Tax Amount ($)</label>
                                <input type="number" step="0.01" min="0" name="tax_amount" id="tax_amount" 
                                       class="form-control" value="<?php echo e(old('tax_amount', $bankInvoice->tax_amount)); ?>">
                                <?php $__errorArgs = ['tax_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status *</label>
                                <select name="status" id="status" class="form-select" required>
                                    <option value="draft" <?php echo e($bankInvoice->status == 'draft' ? 'selected' : ''); ?>>Draft</option>
                                    <option value="sent" <?php echo e($bankInvoice->status == 'sent' ? 'selected' : ''); ?>>Sent</option>
                                    <option value="paid" <?php echo e($bankInvoice->status == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                    <option value="cancelled" <?php echo e($bankInvoice->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                </select>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description *</label>
                        <textarea name="description" id="description" class="form-control" rows="4" required><?php echo e(old('description', $bankInvoice->description)); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="bank_remarks" class="form-label">Bank Remarks</label>
                        <textarea name="bank_remarks" id="bank_remarks" class="form-control" rows="2"><?php echo e(old('bank_remarks', $bankInvoice->bank_remarks)); ?></textarea>
                        <?php $__errorArgs = ['bank_remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?php echo e(route('admin.bank-invoices.index')); ?>" class="btn btn-secondary me-2">Cancel</a>&nbsp;
                        <button type="submit" class="btn btn-primary">Update Invoice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Summary</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Invoice Number:</strong><br>
                    <?php echo e($bankInvoice->invoice_number); ?>

                </div>
                <div class="mb-3">
                    <strong>Total Amount:</strong><br>
                    <span class="fw-bold text-success">$<?php echo e(number_format($bankInvoice->total_amount, 2)); ?></span>
                </div>
                <div class="mb-3">
                    <strong>Current Status:</strong><br>
                    <span class="badge bg-<?php echo e($bankInvoice->status_badge_color); ?> text-white">
                        <?php echo e(ucfirst($bankInvoice->status)); ?>

                    </span>
                </div>
                <div class="mb-3">
                    <strong>Due Status:</strong><br>
                    <?php if($bankInvoice->is_overdue): ?>
                    <span class="badge bg-danger text-white">Overdue</span>
                    <?php else: ?>
                    <span class="badge bg-success text-white">On Time</span>
                    <?php endif; ?>
                </div>
                <div class="mb-3">
                    <strong>Created By:</strong><br>
                    <?php echo e($bankInvoice->creator->name); ?><br>
                    <small class="text-muted"><?php echo e($bankInvoice->created_at->format('M d, Y H:i')); ?></small>
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong><br>
                    <small class="text-muted"><?php echo e($bankInvoice->updated_at->format('M d, Y H:i')); ?></small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.bank-invoices.export-pdf', $bankInvoice)); ?>" class="btn btn-outline-primary" target="_blank">
                        <i class="fas fa-file-pdf me-1"></i> Download PDF
                    </a>
                    <?php if($bankInvoice->status === 'draft'): ?>
                    <form action="<?php echo e(route('admin.bank-invoices.mark-sent', $bankInvoice)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
                        </button>
                    </form>
                    <?php endif; ?>
                    <?php if($bankInvoice->status === 'sent'): ?>
                    <form action="<?php echo e(route('admin.bank-invoices.mark-paid', $bankInvoice)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i> Mark as Paid
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total amount
function calculateTotal() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const taxAmount = parseFloat(document.getElementById('tax_amount').value) || 0;
    const total = amount + taxAmount;
    document.getElementById('total-amount-preview').textContent = '$' + total.toFixed(2);
}

// Event listeners
document.getElementById('amount').addEventListener('input', calculateTotal);
document.getElementById('tax_amount').addEventListener('input', calculateTotal);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
});
</script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/bank-invoices/edit.blade.php ENDPATH**/ ?>