<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Advance Payment Details'); ?>

    <a href="<?php echo e(route('admin.advance-payments.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Payments
    </a>
    <a href="<?php echo e(route('admin.advance-payments.edit', $advancePayment)); ?>" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
    <?php if($advancePayment->canAllocate()): ?>
    <a href="<?php echo e(route('admin.payment-allocations.create')); ?>?advance_payment_id=<?php echo e($advancePayment->id); ?>" 
       class="btn btn-success">
        <i class="fas fa-share-alt me-1"></i> Allocate to Factory
    </a>
    <?php endif; ?>

<div class="row mt-5">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Reference Number</th>
                                <td><?php echo e($advancePayment->reference_number); ?></td>
                            </tr>
                            <tr>
                                <th>Buyer</th>
                                <td><?php echo e($advancePayment->buyer->contact_person); ?></td>
                            </tr>
                            <tr>
                                <th>Order Confirmation</th>
                                <td><?php echo e($advancePayment->orderConfirmation->order_number ?? 'N/A'); ?></td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td class="fw-bold text-success">$<?php echo e(number_format($advancePayment->amount, 2)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Payment Date</th>
                                <td><?php echo e($advancePayment->payment_date->format('M d, Y')); ?></td>
                            </tr>
                            <tr>
                                <th>Payment Method</th>
                                <td class="text-uppercase"><?php echo e($advancePayment->payment_method); ?></td>
                            </tr>
                            <tr>
                                <th>Transaction ID</th>
                                <td><?php echo e($advancePayment->transaction_id ?? 'N/A'); ?></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span class="badge bg-<?php echo e($advancePayment->status_badge_color); ?>">
                                        <?php echo e(ucfirst($advancePayment->status)); ?>

                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Allocated Amount</th>
                                <td class="fw-bold text-danger">$<?php echo e(number_format($advancePayment->allocated_amount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th>Remaining Amount</th>
                                <td class="fw-bold text-success">$<?php echo e(number_format($advancePayment->remaining_amount, 2)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Created By</th>
                                <td><?php echo e($advancePayment->creator->name); ?></td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td><?php echo e($advancePayment->created_at->format('M d, Y H:i')); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <?php if($advancePayment->remarks): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                <?php echo e($advancePayment->remarks); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Allocations Section -->
        <?php if($advancePayment->allocations->count() > 0): ?>
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment Allocations</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Reference</th>
                                <th>Factory</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Purpose</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $advancePayment->allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($allocation->reference_number); ?></td>
                                <td><?php echo e($allocation->factory->name); ?></td>
                                <td><?php echo e($allocation->orderConfirmation->order_number); ?></td>
                                <td class="text-danger">$<?php echo e(number_format($allocation->amount, 2)); ?></td>
                                <td><?php echo e($allocation->allocation_date->format('M d, Y')); ?></td>
                                <td><?php echo e(Str::limit($allocation->purpose, 50)); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.payment-allocations.show', $allocation)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <h6><?php echo e($advancePayment->buyer->company_name); ?></h6>
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> <?php echo e($advancePayment->buyer->contact_person); ?></li>
                    <li><strong>Email:</strong> <?php echo e($advancePayment->buyer->email); ?></li>
                    <li><strong>Phone:</strong> <?php echo e($advancePayment->buyer->phone); ?></li>
                    <li><strong>Address:</strong> <?php echo e($advancePayment->buyer->address); ?></li>
                </ul>
                
                <a href="<?php echo e(route('admin.payment.ledger.buyer', $advancePayment->buyer)); ?>" class="btn btn-sm btn-outline-primary">
                    View Buyer Ledger
                </a>
            </div>
        </div>
        
        <?php if($advancePayment->orderConfirmation): ?>
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Order Information</h6>
            </div>
            <div class="card-body">
                <h6><?php echo e($advancePayment->orderConfirmation->order_number); ?></h6>
                <ul class="list-unstyled">
                    <li><strong>Quantity:</strong> <?php echo e(number_format($advancePayment->orderConfirmation->confirmed_quantity)); ?></li>
                    <li><strong>Price:</strong> $<?php echo e(number_format($advancePayment->orderConfirmation->confirmed_price, 2)); ?></li>
                    <li><strong>Delivery:</strong> <?php echo e($advancePayment->orderConfirmation->formatted_delivery_date); ?></li>
                    <li><strong>Status:</strong> 
                        <span class="badge bg-<?php echo e($advancePayment->orderConfirmation->status_badge_color); ?>">
                            <?php echo e(ucfirst($advancePayment->orderConfirmation->status)); ?>

                        </span>
                    </li>
                </ul>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/advance-payments/show.blade.php ENDPATH**/ ?>