<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Packing List - <?php echo e($shipment->shipment_number); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #333; padding-bottom: 15px; }
        .company-name { font-size: 20px; font-weight: bold; }
        .packing-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .packing-table th, .packing-table td { padding: 8px; border: 1px solid #333; text-align: left; }
        .packing-table th { background: #333; color: white; }
        .summary { margin-top: 30px; padding: 15px; border: 1px solid #333; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">FINAL PACKING LIST</div>
        <div>Shipment: <?php echo e($shipment->shipment_number); ?></div>
    </div>

    <table class="packing-table">
        <thead>
            <tr>
                <th>Carton No</th>
                <th>Quantity</th>
                <th>Gross Weight (kg)</th>
                <th>Net Weight (kg)</th>
                <th>Volume (m³)</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $shipment->cartonDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carton): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($carton->carton_number); ?></td>
                <td><?php echo e(number_format($carton->quantity)); ?></td>
                <td><?php echo e($carton->gross_weight ? number_format($carton->gross_weight, 2) : 'N/A'); ?></td>
                <td><?php echo e($carton->net_weight ? number_format($carton->net_weight, 2) : 'N/A'); ?></td>
                <td><?php echo e($carton->volume ? number_format($carton->volume, 3) : 'N/A'); ?></td>
                <td><?php echo e($carton->description); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="summary">
        <strong>Final Shipment Summary:</strong><br>
        Original Quantity: <?php echo e(number_format($finalShipment->original_quantity)); ?><br>
        Adjusted Quantity: <?php echo e($finalShipment->adjusted_quantity >= 0 ? '+' : ''); ?><?php echo e(number_format($finalShipment->adjusted_quantity)); ?><br>
        Final Quantity: <?php echo e(number_format($finalShipment->final_quantity)); ?><br>
        Adjustment Reason: <?php echo e($finalShipment->adjustment_reason); ?>

    </div>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/final-shipments/export/packing-list.blade.php ENDPATH**/ ?>