<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Add Carton Details - <?php echo e($shipment->shipment_number); ?></h4>
                <a href="<?php echo e(route('admin.shipments.carton-details.index', $shipment)); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Cartons
                </a>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Add Carton Details</h5>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.shipments.carton-details.store', $shipment)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="carton_number" class="form-label">Carton Number *</label>
                                            <input type="text" name="carton_number" id="carton_number" 
                                                   class="form-control" value="<?php echo e(old('carton_number')); ?>" 
                                                   placeholder="e.g., CARTON-001" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="quantity" class="form-label">Quantity *</label>
                                            <input type="number" name="quantity" id="quantity" 
                                                   class="form-control" value="<?php echo e(old('quantity')); ?>" 
                                                   min="1" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="gross_weight" class="form-label">Gross Weight (kg)</label>
                                            <input type="number" step="0.01" name="gross_weight" id="gross_weight" 
                                                   class="form-control" value="<?php echo e(old('gross_weight')); ?>" 
                                                   min="0">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="net_weight" class="form-label">Net Weight (kg)</label>
                                            <input type="number" step="0.01" name="net_weight" id="net_weight" 
                                                   class="form-control" value="<?php echo e(old('net_weight')); ?>" 
                                                   min="0">
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="volume" class="form-label">Volume (m³)</label>
                                            <input type="number" step="0.001" name="volume" id="volume" 
                                                   class="form-control" value="<?php echo e(old('volume')); ?>" 
                                                   min="0">
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" class="form-control" rows="3" 
                                              placeholder="Description of carton contents..."><?php echo e(old('description')); ?></textarea>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="reset" class="btn btn-secondary">Reset</button>
                                    <button type="submit" class="btn btn-primary">Add Carton</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Shipment Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Shipment:</strong><br>
                                <?php echo e($shipment->shipment_number); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Order:</strong><br>
                                <?php echo e($shipment->orderConfirmation->order_number); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Current Cartons:</strong><br>
                                <?php echo e($shipment->cartonDetails->count()); ?>

                            </div>
                            <div class="mb-3">
                                <strong>Total Quantity:</strong><br>
                                <?php echo e(number_format($shipment->total_quantity)); ?>

                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Guidelines</h6>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled">
                                <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Use unique carton numbers</li>
                                <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Provide accurate quantities</li>
                                <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Include weight and volume if available</li>
                                <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Add description for easy identification</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/carton-details/create.blade.php ENDPATH**/ ?>