<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Ledger Report - <?php echo e($buyer->company_name); ?></title>
    <style>
        body { 
            font-family: DejaVu Sans, sans-serif; 
            font-size: 12px; 
            line-height: 1.4;
        }
        .header { 
            text-align: center; 
            margin-bottom: 30px; 
            border-bottom: 2px solid #333; 
            padding-bottom: 20px; 
        }
        .company-name { 
            font-size: 24px; 
            font-weight: bold; 
            margin-bottom: 5px; 
            color: #2c3e50;
        }
        .report-title { 
            font-size: 20px; 
            margin: 20px 0; 
            color: #34495e;
        }
        .summary-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        .summary-table td { 
            padding: 10px; 
            border: 1px solid #333; 
        }
        .summary-table .label { 
            font-weight: bold; 
            background: #f8f9fa; 
            width: 40%; 
        }
        .details-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        .details-table th, .details-table td { 
            padding: 8px; 
            border: 1px solid #ddd; 
            text-align: left;
        }
        .details-table th { 
            background: #333; 
            color: white; 
        }
        .footer { 
            margin-top: 50px; 
            padding-top: 20px; 
            border-top: 1px solid #ddd; 
        }
        .text-success { color: #28a745; }
        .text-danger { color: #dc3545; }
        .text-bold { font-weight: bold; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">Textile Export Company</div>
        <div>123 Textile Street, Industrial Area, City - 123456</div>
        <div>Phone: +91-1234567890 | Email: info@textileexport.com</div>
    </div>

    <div class="report-title">PAYMENT LEDGER REPORT</div>

    <table class="summary-table">
        <tr>
            <td class="label">Buyer Name:</td>
            <td><?php echo e($buyer->company_name); ?></td>
        </tr>
        <tr>
            <td class="label">Report Date:</td>
            <td><?php echo e(date('d/m/Y H:i')); ?></td>
        </tr>
        <tr>
            <td class="label">Total Payments In:</td>
            <td class="text-success text-bold">$<?php echo e(number_format($ledger->total_in, 2)); ?></td>
        </tr>
        <tr>
            <td class="label">Total Allocations Out:</td>
            <td class="text-danger text-bold">$<?php echo e(number_format($ledger->total_out, 2)); ?></td>
        </tr>
        <tr>
            <td class="label">Current Balance:</td>
            <td class="text-bold <?php echo e($ledger->current_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                $<?php echo e(number_format($ledger->current_balance, 2)); ?>

            </td>
        </tr>
    </table>

    <h3>Advance Payments</h3>
    <table class="details-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Reference</th>
                <th>Order</th>
                <th>Amount</th>
                <th>Allocated</th>
                <th>Balance</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $advancePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($payment->payment_date->format('d/m/Y')); ?></td>
                <td><?php echo e($payment->reference_number); ?></td>
                <td><?php echo e($payment->orderConfirmation->order_number ?? 'N/A'); ?></td>
                <td class="text-success">$<?php echo e(number_format($payment->amount, 2)); ?></td>
                <td class="text-danger">$<?php echo e(number_format($payment->allocated_amount, 2)); ?></td>
                <td class="text-bold <?php echo e($payment->remaining_amount > 0 ? 'text-success' : 'text-secondary'); ?>">
                    $<?php echo e(number_format($payment->remaining_amount, 2)); ?>

                </td>
                <td><?php echo e(ucfirst($payment->status)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <h3>Payment Allocations</h3>
    <table class="details-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Reference</th>
                <th>Factory</th>
                <th>Order</th>
                <th>Amount</th>
                <th>Purpose</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($allocation->allocation_date->format('d/m/Y')); ?></td>
                <td><?php echo e($allocation->reference_number); ?></td>
                <td><?php echo e($allocation->factory->name); ?></td>
                <td><?php echo e($allocation->orderConfirmation->order_number); ?></td>
                <td class="text-danger">$<?php echo e(number_format($allocation->amount, 2)); ?></td>
                <td><?php echo e($allocation->purpose); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <div style="text-align: center; font-size: 10px; color: #666;">
            Generated on: <?php echo e(date('d/m/Y H:i')); ?> | Page 1 of 1
        </div>
    </div>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/ledger/buyer-report.blade.php ENDPATH**/ ?>