<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container mt-5">
    <h2 class="mb-4">Banks List</h2>

    <a href="<?php echo e(route('admin.banks.create')); ?>" class="btn btn-success mb-3">
        <i class="fas fa-plus"></i> Add Bank
    </a>
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>A/C Name</th>
                <th>A/C No</th>
                <th>IBAN</th>
                <th>SWIFT</th>
                <th>Bank Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($bank->id); ?></td>
                    <td><?php echo e($bank->account_name); ?></td>
                    <td><?php echo e($bank->account_no); ?></td>
                    <td><?php echo e($bank->iban); ?></td>
                    <td><?php echo e($bank->swift); ?></td>
                    <td><?php echo e($bank->bank_name); ?></td>
                    <td>
                        <a href="<?php echo e(route('admin.banks.edit', $bank->id)); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i>
                        </a>

                          <a href="<?php echo e(route('admin.banks.show', $bank->id)); ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-eye"></i>
                        </a>
                        <form action="<?php echo e(route('admin.banks.destroy', $bank->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/banks/index.blade.php ENDPATH**/ ?>