<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Payment Allocations'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.payment-allocations.create')); ?>" class="btn btn-primary">
        <i class="fas fa-share-alt me-1"></i> Allocate Payment
    </a>
    <a href="<?php echo e(route('admin.advance-payments.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-money-bill-wave me-1"></i> View Payments
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Payment Allocations to Factories</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Buyer</th>
                        <th>Factory</th>
                        <th>Order</th>
                        <th>Amount</th>
                        <th>Allocation Date</th>
                        <th>Purpose</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($allocation->reference_number); ?></td>
                        <td><?php echo e($allocation->advancePayment->buyer->company_name); ?></td>
                        <td><?php echo e($allocation->factory->name); ?></td>
                        <td><?php echo e($allocation->orderConfirmation->order_number); ?></td>
                        <td class="fw-bold text-danger">$<?php echo e(number_format($allocation->amount, 2)); ?></td>
                        <td><?php echo e($allocation->allocation_date->format('M d, Y')); ?></td>
                        <td><?php echo e(Str::limit($allocation->purpose, 50)); ?></td>
                        <td class="table-actions">
                            <a href="<?php echo e(route('admin.payment-allocations.show', $allocation)); ?>" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.payment-allocations.edit', $allocation)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.payment-allocations.destroy', $allocation)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            <?php echo e($allocations->links()); ?>

        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Allocations</h6>
                <h3><?php echo e($allocations->total()); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">This Page Amount</h6>
                <h3>$<?php echo e(number_format($allocations->sum('amount'), 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h6 class="card-title">Total Factories</h6>
                <h3><?php echo e($allocations->unique('factory_id')->count()); ?></h3>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/allocations/index.blade.php ENDPATH**/ ?>