<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Document Generator</li>
                    </ol>
                </div>
                <h4 class="page-title">Final Invoice & Packing List</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="card-title">Generate Documents</h5>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="<?php echo e(route('admin.export-center.index')); ?>" class="btn btn-outline-primary">
                                <i class="fas fa-download me-1"></i> Export Center
                            </a>
                        </div>
                    </div>

                    <form id="documentGeneratorForm">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="order_confirmation_id" class="form-label">Select Order <span class="text-danger">*</span></label>
                                    <select class="form-select" id="order_confirmation_id" name="order_confirmation_id" required>
                                        <option value="">Select Order</option>
                                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($order->id); ?>" data-buyer="<?php echo e($order->customer_po_number ?? $order->order_number); ?>">
                                            <?php echo e($order->order_number); ?> - PO: <?php echo e($order->customer_po_number ?? 'N/A'); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Document Types <span class="text-danger">*</span></label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="commercial_invoice" id="commercial_invoice">
                                                <label class="form-check-label" for="commercial_invoice">Commercial Invoice</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="packing_list" id="packing_list">
                                                <label class="form-check-label" for="packing_list">Packing List</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="certificate_origin" id="certificate_origin">
                                                <label class="form-check-label" for="certificate_origin">Certificate of Origin</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="bill_of_lading" id="bill_of_lading">
                                                <label class="form-check-label" for="bill_of_lading">Bill of Lading</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="inspection_certificate" id="inspection_certificate">
                                                <label class="form-check-label" for="inspection_certificate">Inspection Certificate</label>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" name="document_types[]" value="shipping_label" id="shipping_label">
                                                <label class="form-check-label" for="shipping_label">Shipping Label</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="template_id" class="form-label">Template (Optional)</label>
                                    <select class="form-select" id="template_id" name="template_id">
                                        <option value="">Use Default Template</option>
                                        <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($template->id); ?>"><?php echo e($template->name); ?> (<?php echo e($template->type); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Options</label>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="include_signature" value="1" id="include_signature">
                                        <label class="form-check-label" for="include_signature">Include Signature</label>
                                    </div>
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" name="include_terms" value="1" id="include_terms">
                                        <label class="form-check-label" for="include_terms">Include Terms & Conditions</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit" class="btn btn-success" id="generateBtn">
                                    <i class="fas fa-file-pdf me-1"></i> Generate Documents
                                </button>
                                <button type="button" class="btn btn-outline-info" id="previewBtn">
                                    <i class="fas fa-eye me-1"></i> Preview
                                </button>
                            </div>
                        </div>
                    </form>

                    <div id="generationResult" class="mt-3" style="display: none;"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('documentGeneratorForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const generateBtn = document.getElementById('generateBtn');
    const originalText = generateBtn.innerHTML;
    
    generateBtn.disabled = true;
    generateBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i> Generating...';
    
    fetch('<?php echo e(route("admin.document-generator.generate-documents")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const resultDiv = document.getElementById('generationResult');
            resultDiv.innerHTML = `
                <div class="alert alert-success">
                    <h5><i class="fas fa-check-circle me-2"></i> ${data.message}</h5>
                    <div class="mt-2">
                        <a href="<?php echo e(route('admin.export-center.index')); ?>" class="btn btn-sm btn-primary">
                            <i class="fas fa-download me-1"></i> Go to Export Center
                        </a>
                    </div>
                </div>
            `;
            resultDiv.style.display = 'block';
            document.getElementById('documentGeneratorForm').reset();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while generating documents.');
    })
    .finally(() => {
        generateBtn.disabled = false;
        generateBtn.innerHTML = originalText;
    });
});
</script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/invoice-packing/index.blade.php ENDPATH**/ ?>