<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Final Shipment Updates - <?php echo e($shipment->shipment_number); ?></h4>
                <div>
                    <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Shipment
                    </a>
                    <a href="<?php echo e(route('admin.shipments.final-shipments.create', $shipment)); ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Final Update
                    </a>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Final Shipment Updates</h5>
                </div>
                <div class="card-body">
                    <?php if($finalShipments->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Final Shipment Date</th>
                                    <th>Original Qty</th>
                                    <th>Adjusted Qty</th>
                                    <th>Final Qty</th>
                                    <th>Adjustment Type</th>
                                    <th>Status</th>
                                    <th>Inspection Remarks</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $finalShipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $final): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($final->final_shipment_date->format('M d, Y')); ?></td>
                                    <td><?php echo e(number_format($final->original_quantity)); ?></td>
                                    <td class="<?php echo e($final->adjusted_quantity >= 0 ? 'text-success' : 'text-danger'); ?>">
                                        <?php echo e($final->adjusted_quantity >= 0 ? '+' : ''); ?><?php echo e(number_format($final->adjusted_quantity)); ?>

                                    </td>
                                    <td class="fw-bold text-primary"><?php echo e(number_format($final->final_quantity)); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($final->adjustment_type == 'positive' ? 'success' : 'danger'); ?>">
                                            <?php echo e($final->adjustment_type == 'positive' ? 'Increase' : 'Decrease'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($final->status_badge_color); ?>">
                                            <?php echo e(ucfirst($final->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e(Str::limit($final->inspection_remarks, 30)); ?></td>
                                    <td class="table-actions">
                                        <a href="<?php echo e(route('admin.shipments.final-shipments.show', [$shipment, $final])); ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.shipments.final-shipments.edit', [$shipment, $final])); ?>" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.shipments.final-shipments.destroy', [$shipment, $final])); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-ship fa-3x mb-3"></i>
                        <p>No final shipment updates yet.</p>
                        <a href="<?php echo e(route('admin.shipments.final-shipments.create', $shipment)); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Create First Update
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Summary Cards -->
            <?php if($finalShipments->count() > 0): ?>
            <div class="row mt-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <h6 class="card-title">Total Updates</h6>
                            <h3><?php echo e($finalShipments->count()); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h6 class="card-title">Positive Adjustments</h6>
                            <h3><?php echo e($finalShipments->where('adjusted_quantity', '>', 0)->count()); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-dark">
                        <div class="card-body">
                            <h6 class="card-title">Negative Adjustments</h6>
                            <h3><?php echo e($finalShipments->where('adjusted_quantity', '<', 0)->count()); ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <h6 class="card-title">Completed</h6>
                            <h3><?php echo e($finalShipments->where('status', 'completed')->count()); ?></h3>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/final-shipments/index.blade.php ENDPATH**/ ?>