<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container">
    <h4 class="mb-3">Factory List</h4>
    <a href="<?php echo e(route('admin.factories.create')); ?>" class="btn btn-primary mb-3" style="float: right;"><i class="fas fa-plus"></i> Add Factory</a>

       <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="zmdi zmdi-check-circle"></i> <?php echo e(session('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="factoryTable">
            <thead class="thead-dark">
                <tr>
                    <th>Name</th>
                    <th>Location</th>
                    <th>Contact Person</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Compliance</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($factory->name); ?></td>
                        <td><?php echo e($factory->location); ?></td>
                        <td><?php echo e($factory->contact_person); ?></td>
                        <td><?php echo e($factory->phone); ?></td>
                        <td><?php echo e($factory->email); ?></td>
                        <td>
                       <?php if(isset($factory->compliance_doc)): ?>
    <small>Current: <a href="<?php echo e(asset($factory->compliance_doc)); ?>" target="_blank">View File</a></small>
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>
                        <td>
<div class="dropdown">
    <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="buyerActionsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
        Actions
    </button>
    <ul class="dropdown-menu" aria-labelledby="buyerActionsDropdown">
        <li>
           
                            <a href="<?php echo e(route('admin.factories.edit', $factory->id)); ?>" class="dropdown-item  "><i class="fas fa-edit"></i> Udpate</a>
        </li>
      
        <li>    
                            <form action="<?php echo e(route('admin.factories.destroy', $factory->id)); ?>" method="POST" style="display:inline-block;">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button class=" dropdown-item" onclick="return confirm('Delete?')"><i class="fas fa-trash"></i> Remove</button>
                            </form>

                    </li>
    </ul>
</div>


                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-4">
    <?php echo e($factories->links()); ?>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>





<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/factories/index.blade.php ENDPATH**/ ?>