<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Commercial Invoice - <?php echo e($order->order_number ?? 'N/A'); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; }
        .section { margin-bottom: 15px; }
        .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; }
        .text-right { text-align: right; }
        .signature { margin-top: 50px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>COMMERCIAL INVOICE</h2>
        <p>Invoice No: <?php echo e($order->order_number ?? 'N/A'); ?></p>
        <p>Date: <?php echo e(now()->format('M d, Y')); ?></p>
    </div>

    <div class="section">
        <div class="section-title">Order Information</div>
        <table>
            <tr>
                <td width="25%"><strong>Order Number:</strong></td>
                <td><?php echo e($order->order_number ?? 'N/A'); ?></td>
                <td width="25%"><strong>Customer PO:</strong></td>
                <td><?php echo e($order->customer_po_number ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Quantity:</strong></td>
                <td><?php echo e($order->confirmed_quantity ?? 'N/A'); ?></td>
                <td><strong>Price:</strong></td>
                <td>$<?php echo e(number_format($order->confirmed_price, 2) ?? '0.00'); ?></td>
            </tr>
            <tr>
                <td><strong>Delivery Date:</strong></td>
                <td><?php echo e($order->delivery_date ? $order->delivery_date->format('M d, Y') : 'N/A'); ?></td>
                <td><strong>Total Value:</strong></td>
                <td>$<?php echo e(number_format($order->confirmed_quantity * $order->confirmed_price, 2)); ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Payment Terms</div>
        <p><?php echo e($order->payment_terms ?? 'Standard payment terms apply'); ?></p>
    </div>

    <?php if($order->special_instructions): ?>
    <div class="section">
        <div class="section-title">Special Instructions</div>
        <p><?php echo e($order->special_instructions); ?></p>
    </div>
    <?php endif; ?>

    <?php if($include_signature): ?>
    <div class="signature">
        <table>
            <tr>
                <td width="50%">
                    <strong>Seller Signature:</strong><br><br>
                    _________________________<br>
                    Name: ___________________<br>
                    Date: ___________________
                </td>
                <td width="50%">
                    <strong>Buyer Signature:</strong><br><br>
                    _________________________<br>
                    Name: ___________________<br>
                    Date: ___________________
                </td>
            </tr>
        </table>
    </div>
    <?php endif; ?>

    <?php if($include_terms): ?>
    <div class="section">
        <div class="section-title">Terms & Conditions</div>
        <p>1. All payments must be made in full before shipment.<br>
           2. Delivery dates are estimates and not guaranteed.<br>
           3. Returns must be requested within 7 days of receipt.</p>
    </div>
    <?php endif; ?>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/templates/commercial_invoice.blade.php ENDPATH**/ ?>