<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Allocate Payment to Factory'); ?>

    <a href="<?php echo e(route('admin.payment-allocations.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Allocations
    </a>

<div class="row mt-3">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Allocate Payment to Factory</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.payment-allocations.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="advance_payment_id" class="form-label">Advance Payment *</label>
                                <select name="advance_payment_id" id="advance_payment_id" class="form-select" required>
                                    <option value="">Select Advance Payment</option>
                                    <?php $__currentLoopData = $advancePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($payment->id); ?>" 
                                        <?php echo e(request('advance_payment_id') == $payment->id ? 'selected' : ''); ?>

                                        data-remaining="<?php echo e($payment->remaining_amount); ?>">
                                        <?php echo e($payment->reference_number); ?> - <?php echo e($payment->buyer->company_name); ?> ($<?php echo e(number_format($payment->remaining_amount, 2)); ?> available)
                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['advance_payment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="factory_id" class="form-label">Factory *</label>
                                <select name="factory_id" id="factory_id" class="form-select" required>
                                    <option value="">Select Factory</option>
                                    <?php $__currentLoopData = $factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($factory->id); ?>" <?php echo e(old('factory_id') == $factory->id ? 'selected' : ''); ?>>
                                        <?php echo e($factory->name); ?> - <?php echo e($factory->location); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['factory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($order->id); ?>" <?php echo e(old('order_confirmation_id') == $order->id ? 'selected' : ''); ?>>
                                        <?php echo e($order->order_number); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['order_confirmation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Allocation Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="<?php echo e(old('amount')); ?>" required>
                                <small class="form-text text-muted">
                                    Available: $<span id="available-amount">0.00</span>
                                </small>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="allocation_date" class="form-label">Allocation Date *</label>
                                <input type="date" name="allocation_date" id="allocation_date" 
                                       class="form-control" value="<?php echo e(old('allocation_date', date('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['allocation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="purpose" class="form-label">Purpose *</label>
                        <textarea name="purpose" id="purpose" class="form-control" rows="3" 
                                  placeholder="Describe the purpose of this allocation..." required><?php echo e(old('purpose')); ?></textarea>
                        <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="2" 
                                  placeholder="Any additional remarks..."><?php echo e(old('remarks')); ?></textarea>
                        <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                        <button type="submit" class="btn btn-primary">Allocate Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Allocation Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Select advance payment with available balance</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Allocation amount cannot exceed available balance</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Provide clear purpose for tracking</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Allocations are irreversible once saved</li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Available Payments</h6>
            </div>
            <div class="card-body">
                <?php if($advancePayments->count() > 0): ?>
                    <?php $__currentLoopData = $advancePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border-bottom pb-2 mb-2">
                        <small class="fw-bold"><?php echo e($payment->reference_number); ?></small><br>
                        <small><?php echo e($payment->buyer->company_name); ?></small><br>
                        <small class="text-success">Available: $<?php echo e(number_format($payment->remaining_amount, 2)); ?></small>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="text-center text-muted">
                        <i class="fas fa-exclamation-triangle fa-2x mb-2"></i>
                        <p>No advance payments with available balance</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('advance_payment_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    const remainingAmount = selectedOption.getAttribute('data-remaining') || 0;
    document.getElementById('available-amount').textContent = parseFloat(remainingAmount).toFixed(2);
    
    // Set max value for amount input
    const amountInput = document.getElementById('amount');
    amountInput.setAttribute('max', remainingAmount);
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    const advanceSelect = document.getElementById('advance_payment_id');
    if (advanceSelect.value) {
        advanceSelect.dispatchEvent(new Event('change'));
    }
});
</script>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/allocations/create.blade.php ENDPATH**/ ?>