<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Payment Allocation Details'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.payment-allocations.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Allocations
    </a>
    <a href="<?php echo e(route('admin.payment-allocations.edit', $paymentAllocation)); ?>" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Allocation Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Reference Number</th>
                                <td><?php echo e($paymentAllocation->reference_number); ?></td>
                            </tr>
                            <tr>
                                <th>Advance Payment</th>
                                <td>
                                    <a href="<?php echo e(route('admin.advance-payments.show', $paymentAllocation->advancePayment)); ?>" class="text-decoration-none">
                                        <?php echo e($paymentAllocation->advancePayment->reference_number); ?>

                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <th>Buyer</th>
                                <td><?php echo e($paymentAllocation->advancePayment->buyer->company_name); ?></td>
                            </tr>
                            <tr>
                                <th>Factory</th>
                                <td><?php echo e($paymentAllocation->factory->name); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Order Confirmation</th>
                                <td><?php echo e($paymentAllocation->orderConfirmation->order_number); ?></td>
                            </tr>
                            <tr>
                                <th>Allocation Date</th>
                                <td><?php echo e($paymentAllocation->allocation_date->format('M d, Y')); ?></td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td class="fw-bold text-danger">$<?php echo e(number_format($paymentAllocation->amount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th>Created By</th>
                                <td><?php echo e($paymentAllocation->creator->name); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Purpose</label>
                            <div class="border p-3 bg-light rounded">
                                <?php echo e($paymentAllocation->purpose); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <?php if($paymentAllocation->remarks): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                <?php echo e($paymentAllocation->remarks); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Related Information</h6>
            </div>
            <div class="card-body">
                <h6>Advance Payment Details</h6>
                <ul class="list-unstyled">
                    <li><strong>Amount:</strong> $<?php echo e(number_format($paymentAllocation->advancePayment->amount, 2)); ?></li>
                    <li><strong>Payment Date:</strong> <?php echo e($paymentAllocation->advancePayment->payment_date->format('M d, Y')); ?></li>
                    <li><strong>Method:</strong> <?php echo e(strtoupper($paymentAllocation->advancePayment->payment_method)); ?></li>
                    <li><strong>Remaining:</strong> $<?php echo e(number_format($paymentAllocation->advancePayment->remaining_amount, 2)); ?></li>
                </ul>
                
                <hr>
                
                <h6>Factory Details</h6>
                <ul class="list-unstyled">
                    <li><strong>Name:</strong> <?php echo e($paymentAllocation->factory->name); ?></li>
                    <li><strong>Location:</strong> <?php echo e($paymentAllocation->factory->location); ?></li>
                    <li><strong>Contact:</strong> <?php echo e($paymentAllocation->factory->contact_person); ?></li>
                    <li><strong>Email:</strong> <?php echo e($paymentAllocation->factory->email); ?></li>
                </ul>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Timeline</h6>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <div class="timeline-item">
                        <small class="text-muted">Created</small>
                        <div><?php echo e($paymentAllocation->created_at->format('M d, Y H:i')); ?></div>
                        <div>by <?php echo e($paymentAllocation->creator->name); ?></div>
                    </div>
                    <div class="timeline-item mt-2">
                        <small class="text-muted">Last Updated</small>
                        <div><?php echo e($paymentAllocation->updated_at->format('M d, Y H:i')); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/allocations/show.blade.php ENDPATH**/ ?>