<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Create Bank Invoice'); ?>

    <a href="<?php echo e(route('admin.bank-invoices.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>

<div class="row mt-5">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Create Bank Invoice</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.bank-invoices.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="buyer_id" class="form-label">Buyer *</label>
                                <select name="buyer_id" id="buyer_id" class="form-select" required>
                                    <option value="">Select Buyer</option>
                                    <?php $__currentLoopData = $buyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $buyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($buyer->id); ?>" <?php echo e(old('buyer_id') == $buyer->id ? 'selected' : ''); ?>>
                                        <?php echo e($buyer->company_name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['buyer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($order->id); ?>" <?php echo e(old('order_confirmation_id') == $order->id ? 'selected' : ''); ?>>
                                        <?php echo e($order->order_number); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['order_confirmation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_date" class="form-label">Invoice Date *</label>
                                <input type="date" name="invoice_date" id="invoice_date" 
                                       class="form-control" value="<?php echo e(old('invoice_date', date('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['invoice_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" name="due_date" id="due_date" 
                                       class="form-control" value="<?php echo e(old('due_date', date('Y-m-d', strtotime('+30 days')))); ?>" required>
                                <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Invoice Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="<?php echo e(old('amount')); ?>" required>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tax_amount" class="form-label">Tax Amount ($)</label>
                                <input type="number" step="0.01" min="0" name="tax_amount" id="tax_amount" 
                                       class="form-control" value="<?php echo e(old('tax_amount', 0)); ?>">
                                <?php $__errorArgs = ['tax_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description *</label>
                        <textarea name="description" id="description" class="form-control" rows="4" 
                                  placeholder="Provide detailed description of goods/services..." required><?php echo e(old('description')); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="bank_remarks" class="form-label">Bank Remarks</label>
                        <textarea name="bank_remarks" id="bank_remarks" class="form-control" rows="2" 
                                  placeholder="Any specific instructions for the bank..."><?php echo e(old('bank_remarks')); ?></textarea>
                        <?php $__errorArgs = ['bank_remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                      &nbsp;  <button type="submit" class="btn btn-primary">Create Invoice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Preview</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Invoice Number:</strong><br>
                    <span class="text-muted">Auto-generated</span>
                </div>
                <div class="mb-3">
                    <strong>Total Amount:</strong><br>
                    <span id="total-amount-preview" class="fw-bold">$0.00</span>
                </div>
                <div class="mb-3">
                    <strong>Status:</strong><br>
                    <span class="badge bg-secondary text-white">Draft</span>
                </div>
                <div class="mb-3">
                    <strong>Due In:</strong><br>
                    <span id="due-days-preview" class="text-muted">-</span>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Invoice Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Select correct buyer and order</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Provide clear description</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Set appropriate due date</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Include tax amount if applicable</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i> Invoice will be created as draft</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
// Calculate total amount
function calculateTotal() {
    const amount = parseFloat(document.getElementById('amount').value) || 0;
    const taxAmount = parseFloat(document.getElementById('tax_amount').value) || 0;
    const total = amount + taxAmount;
    document.getElementById('total-amount-preview').textContent = '$' + total.toFixed(2);
}

// Calculate due days
function calculateDueDays() {
    const invoiceDate = new Date(document.getElementById('invoice_date').value);
    const dueDate = new Date(document.getElementById('due_date').value);
    
    if (invoiceDate && dueDate) {
        const diffTime = dueDate - invoiceDate;
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
        document.getElementById('due-days-preview').textContent = diffDays + ' days';
    }
}

// Event listeners
document.getElementById('amount').addEventListener('input', calculateTotal);
document.getElementById('tax_amount').addEventListener('input', calculateTotal);
document.getElementById('invoice_date').addEventListener('change', calculateDueDays);
document.getElementById('due_date').addEventListener('change', calculateDueDays);

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    calculateTotal();
    calculateDueDays();
});
</script>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/bank-invoices/create.blade.php ENDPATH**/ ?>