<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->startSection('title', 'Role Management'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Role Management</h5>
                    <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-1"></i>Create Role
                    </a>
                </div>
                <div class="card-body">
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-hover table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Role Name</th>
                                    <th>Description</th>
                                    <th>Permissions</th>
                                    <th>Users</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <strong><?php echo e($role->name); ?></strong>
                                        <?php if($role->name == 'superadmin'): ?>
                                            <i class="fas fa-crown text-warning ms-1" title="Super Admin"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($role->description); ?></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($role->permissions_count); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($role->admins_count); ?></span>
                                    </td>
                                    <td>
                                        <?php if($role->is_default): ?>
                                            <span class="badge bg-secondary">System</span>
                                        <?php else: ?>
                                            <span class="badge bg-success">Custom</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="<?php echo e(route('admin.roles.permissions', $role)); ?>" class="btn btn-outline-primary" title="Manage Permissions">
                                                <i class="fas fa-key"></i>
                                            </a>
                                            
                                            <?php if(!$role->is_default || auth('admin')->user()->isSuperAdmin()): ?>
                                            <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-outline-warning" title="Edit Role">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php if(!$role->is_default && $role->name != 'superadmin' && $role->admins_count == 0): ?>
                                            <form action="<?php echo e(route('admin.roles.destroy', $role)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-outline-danger" 
                                                        onclick="return confirm('Are you sure you want to delete this role?')"
                                                        title="Delete Role">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if($roles->isEmpty()): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-user-shield fa-3x text-muted mb-3"></i>
                        <h5>No Roles Found</h5>
                        <p class="text-muted">Get started by creating your first role.</p>
                        <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Create First Role
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/roles/index.blade.php ENDPATH**/ ?>