<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Bank Invoices'); ?>
    <a href="<?php echo e(route('admin.bank-invoices.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Create Invoice
    </a>

<div class="card mt-5">
    <div class="card-header">
        <h5 class="card-title mb-0">Invoice to Bank</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Buyer</th>
                        <th>Order</th>
                        <th>Invoice Date</th>
                        <th>Due Date</th>
                        <th>Total Amount</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo e($invoice->is_overdue ? 'table-warning' : ''); ?>">
                        <td><?php echo e($invoice->invoice_number); ?></td>
                        <td><?php echo e($invoice->buyer->company_name); ?></td>
                        <td><?php echo e($invoice->orderConfirmation->order_number); ?></td>
                        <td><?php echo e($invoice->invoice_date->format('M d, Y')); ?></td>
                        <td>
                            <span class="<?php echo e($invoice->is_overdue ? 'text-danger fw-bold' : ''); ?>">
                                <?php echo e($invoice->due_date->format('M d, Y')); ?>

                            </span>
                        </td>
                        <td>$<?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                        <td>
                            <span class="badge text-white bg-<?php echo e($invoice->status_badge_color); ?> status-badge">
                                <?php echo e(ucfirst($invoice->status)); ?>

                            </span>
                            <?php if($invoice->is_overdue): ?>
                            <span class="badge bg-danger status-badge">Overdue</span>
                            <?php endif; ?>
                        </td>
                        <td class="table-actions">
                            <a href="<?php echo e(route('admin.bank-invoices.show', $invoice)); ?>" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.bank-invoices.edit', $invoice)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="<?php echo e(route('admin.bank-invoices.export-pdf', $invoice)); ?>" class="btn btn-sm btn-secondary" target="_blank">
                                <i class="fas fa-download"></i>
                            </a>
                            <?php if($invoice->status === 'draft'): ?>
                            <form action="<?php echo e(route('admin.bank-invoices.mark-sent', $invoice)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-primary" title="Mark as Sent">
                                    <i class="fas fa-paper-plane"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                            <?php if($invoice->status === 'sent'): ?>
                            <form action="<?php echo e(route('admin.bank-invoices.mark-paid', $invoice)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-success" title="Mark as Paid">
                                    <i class="fas fa-check"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                            <form action="<?php echo e(route('admin.bank-invoices.destroy', $invoice)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            <?php echo e($invoices->links()); ?>

        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-title">Total Invoices</h6>
                <h3><?php echo e($invoices->total()); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-title">Paid</h6>
                <h3><?php echo e($invoices->where('status', 'paid')->count()); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body">
                <h6 class="card-title">Pending</h6>
                <h3><?php echo e($invoices->whereIn('status', ['draft', 'sent'])->count()); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <h6 class="card-title">Overdue</h6>
                <h3><?php echo e($invoices->where('is_overdue', true)->count()); ?></h3>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/bank-invoices/index.blade.php ENDPATH**/ ?>