<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <style>
        .table-actions { white-space: nowrap; }
    </style>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4>Carton Details - <?php echo e($shipment->shipment_number); ?></h4>
                    <div>
                        <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Back to Shipment
                        </a>
                        <a href="<?php echo e(route('admin.shipments.carton-details.create', $shipment)); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add Carton
                        </a>
                    </div>
                </div>

                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Packing List (No Value)</h5>
                    </div>
                    <div class="card-body">
                        <?php if($cartons->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Carton No</th>
                                        <th>Quantity</th>
                                        <th>Gross Weight (kg)</th>
                                        <th>Net Weight (kg)</th>
                                        <th>Volume (m³)</th>
                                        <th>Description</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $cartons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carton): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($carton->carton_number); ?></td>
                                        <td><?php echo e(number_format($carton->quantity)); ?></td>
                                        <td><?php echo e($carton->gross_weight ? number_format($carton->gross_weight, 2) : 'N/A'); ?></td>
                                        <td><?php echo e($carton->net_weight ? number_format($carton->net_weight, 2) : 'N/A'); ?></td>
                                        <td><?php echo e($carton->volume ? number_format($carton->volume, 3) : 'N/A'); ?></td>
                                        <td><?php echo e(Str::limit($carton->description, 50)); ?></td>
                                        <td class="table-actions">
                                            <a href="<?php echo e(route('admin.shipments.carton-details.edit', [$shipment, $carton])); ?>" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.shipments.carton-details.destroy', [$shipment, $carton])); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr class="table-dark">
                                        <th>Total</th>
                                        <th><?php echo e(number_format($cartons->sum('quantity'))); ?></th>
                                        <th><?php echo e(number_format($cartons->sum('gross_weight'), 2)); ?></th>
                                        <th><?php echo e(number_format($cartons->sum('net_weight'), 2)); ?></th>
                                        <th><?php echo e(number_format($cartons->sum('volume'), 3)); ?></th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-box fa-3x mb-3"></i>
                            <p>No carton details added yet.</p>
                            <a href="<?php echo e(route('admin.shipments.carton-details.create', $shipment)); ?>" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Add First Carton
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Summary Cards -->
                <div class="row mt-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <h6 class="card-title">Total Cartons</h6>
                                <h3><?php echo e($cartons->count()); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h6 class="card-title">Total Quantity</h6>
                                <h3><?php echo e(number_format($cartons->sum('quantity'))); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <h6 class="card-title">Total Weight</h6>
                                <h3><?php echo e(number_format($cartons->sum('gross_weight'), 2)); ?> kg</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-dark">
                            <div class="card-body">
                                <h6 class="card-title">Total Volume</h6>
                                <h3><?php echo e(number_format($cartons->sum('volume'), 3)); ?> m³</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/carton-details/index.blade.php ENDPATH**/ ?>