<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Inspection Certificate - <?php echo e($order->order_number ?? 'N/A'); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
        .section { margin-bottom: 15px; }
        .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; border: 1px solid #ddd; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; }
        .checklist-table { margin-bottom: 20px; }
        .signature-box { margin-top: 50px; border-top: 1px solid #000; padding-top: 20px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>INSPECTION CERTIFICATE</h2>
        <p><strong>Quality Control Document</strong></p>
    </div>

    <div class="section">
        <table>
            <tr>
                <td width="25%"><strong>Certificate No:</strong></td>
                <td>IC-<?php echo e($order->order_number ?? 'N/A'); ?>-<?php echo e(date('Ymd')); ?></td>
                <td width="25%"><strong>Inspection Date:</strong></td>
                <td><?php echo e(now()->format('M d, Y')); ?></td>
            </tr>
            <tr>
                <td><strong>Order Number:</strong></td>
                <td><?php echo e($order->order_number ?? 'N/A'); ?></td>
                <td><strong>Customer PO:</strong></td>
                <td><?php echo e($order->customer_po_number ?? 'N/A'); ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">PRODUCT INFORMATION</div>
        <table>
            <tr>
                <td width="25%"><strong>Product Description:</strong></td>
                <td>Commercial goods as per order specification</td>
                <td width="25%"><strong>Total Quantity:</strong></td>
                <td><?php echo e($order->confirmed_quantity ?? 'N/A'); ?> units</td>
            </tr>
            <tr>
                <td><strong>Inspection Location:</strong></td>
                <td>[Manufacturing Facility/ Warehouse]</td>
                <td><strong>Inspection Standard:</strong></td>
                <td>AQL 2.5 / ISO 2859-1</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">INSPECTION RESULTS</div>
        
        <table class="checklist-table">
            <thead>
                <tr>
                    <th>Inspection Item</th>
                    <th>Standard</th>
                    <th>Result</th>
                    <th>Status</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Quantity Verification</td>
                    <td>Match order quantity</td>
                    <td><?php echo e($order->confirmed_quantity ?? 'N/A'); ?> units</td>
                    <td><span style="color: green;">✓ PASS</span></td>
                    <td>Quantity confirmed</td>
                </tr>
                <tr>
                    <td>Packaging</td>
                    <td>Proper and secure</td>
                    <td>Standard export packaging</td>
                    <td><span style="color: green;">✓ PASS</span></td>
                    <td>Cartons in good condition</td>
                </tr>
                <tr>
                    <td>Labeling</td>
                    <td>Correct and clear</td>
                    <td>All labels present</td>
                    <td><span style="color: green;">✓ PASS</span></td>
                    <td>Labels match order details</td>
                </tr>
                <tr>
                    <td>Workmanship</td>
                    <td>No major defects</td>
                    <td>Random sample checked</td>
                    <td><span style="color: green;">✓ PASS</span></td>
                    <td>Quality meets standards</td>
                </tr>
                <tr>
                    <td>Documentation</td>
                    <td>Complete and accurate</td>
                    <td>All docs available</td>
                    <td><span style="color: green;">✓ PASS</span></td>
                    <td>Commercial invoice, packing list</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-title">SAMPLING DETAILS</div>
        <table>
            <tr>
                <td width="25%"><strong>Sample Size:</strong></td>
                <td><?php echo e(min(50, $order->confirmed_quantity)); ?> units</td>
                <td width="25%"><strong>Sampling Method:</strong></td>
                <td>Random Sampling</td>
            </tr>
            <tr>
                <td><strong>Defects Found:</strong></td>
                <td>0 Major, 2 Minor</td>
                <td><strong>Acceptance Level:</strong></td>
                <td>Within AQL 2.5 limits</td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">CONCLUSION</div>
        <div style="padding: 15px; background: #f8f9fa; border: 1px solid #ddd;">
            <p><strong>OVERALL RESULT: <span style="color: green;">PASSED</span></strong></p>
            <p>The inspected goods meet the required quality standards and specifications as per the purchase order. 
               The quantity, packaging, labeling, and workmanship are satisfactory. The shipment is approved for dispatch.</p>
        </div>
    </div>

    <?php if($include_signature): ?>
    <div class="signature-box">
        <table>
            <tr>
                <td width="50%">
                    <strong>INSPECTOR:</strong><br><br>
                    _________________________<br>
                    <strong>Name: [Inspector Name]</strong><br>
                    Position: Quality Control Inspector<br>
                    Date: <?php echo e(now()->format('M d, Y')); ?><br>
                    Signature: _________________
                </td>
                <td width="50%">
                    <strong>APPROVED BY:</strong><br><br>
                    _________________________<br>
                    <strong>Name: [Approver Name]</strong><br>
                    Position: Quality Manager<br>
                    Date: <?php echo e(now()->format('M d, Y')); ?><br>
                    Signature: _________________
                </td>
            </tr>
        </table>
        
        <div style="text-align: center; margin-top: 30px;">
            <div style="border: 2px solid #000; width: 120px; height: 120px; margin: 0 auto; display: flex; align-items: center; justify-content: center; font-weight: bold;">
                OFFICIAL<br>STAMP
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if($include_terms): ?>
    <div class="section">
        <div class="section-title">TERMS AND CONDITIONS</div>
        <p>1. This certificate is based on random sampling inspection at the time of examination.<br>
           2. The inspection does not relieve the supplier of responsibility for latent defects.<br>
           3. This certificate is valid only for the specific lot inspected.<br>
           4. The inspection results are confidential and intended only for the parties involved.</p>
    </div>
    <?php endif; ?>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/templates/inspection_certificate.blade.php ENDPATH**/ ?>