<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Include ApexCharts CSS & JS -->
<link href="https://cdn.jsdelivr.net/npm/apexcharts@3.35.5/dist/apexcharts.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.35.5/dist/apexcharts.min.js"></script>

<div class="container-fluid">
    <!-- Header Section -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <div>
                    <h4 class="page-title mb-0">Reports & Analytics Dashboard</h4>
                    <p class="text-muted mt-1">Comprehensive insights into your business performance</p>
                </div>
                <div class="page-title-right">
                    <div class="dropdown">
                        <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-calendar-alt me-1"></i> Last 30 Days
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#">Last 7 Days</a></li>
                            <li><a class="dropdown-item" href="#">Last 30 Days</a></li>
                            <li><a class="dropdown-item" href="#">Last 90 Days</a></li>
                            <li><a class="dropdown-item" href="#">This Year</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- KPI Summary Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-uppercase fw-medium text-muted mb-0">Total Quotes</p>
                            <h4 class="mt-2 mb-0"><?php echo e($totalQuotes); ?></h4>
                            <p class="mb-0">
                                <span class="badge bg-success-subtle text-success mt-1">
                                    <i class="fas fa-arrow-up me-1"></i> 12.5%
                                </span>
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded-circle bg-primary bg-opacity-10 p-3">
                                <i class="fas fa-file-invoice-dollar text-primary fs-22"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-uppercase fw-medium text-muted mb-0">Win Rate</p>
                            <h4 class="mt-2 mb-0"><?php echo e(number_format($winRate, 1)); ?>%</h4>
                            <p class="mb-0">
                                <span class="badge bg-success-subtle text-success mt-1">
                                    <i class="fas fa-arrow-up me-1"></i> 3.2%
                                </span>
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded-circle bg-success bg-opacity-10 p-3">
                                <i class="fas fa-trophy text-success fs-22"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-uppercase fw-medium text-muted mb-0">Total Profit</p>
                            <h4 class="mt-2 mb-0">$<?php echo e(number_format($totalProfit, 2)); ?></h4>
                            <p class="mb-0">
                                <span class="badge bg-success-subtle text-success mt-1">
                                    <i class="fas fa-arrow-up me-1"></i> 8.7%
                                </span>
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded-circle bg-warning bg-opacity-10 p-3">
                                <i class="fas fa-dollar-sign text-warning fs-22"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-uppercase fw-medium text-muted mb-0">On-Time Delivery</p>
                            <h4 class="mt-2 mb-0"><?php echo e(number_format($onTimeRate, 1)); ?>%</h4>
                            <p class="mb-0">
                                <span class="badge bg-danger-subtle text-danger mt-1">
                                    <i class="fas fa-arrow-down me-1"></i> 2.1%
                                </span>
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <div class="avatar-sm rounded-circle bg-info bg-opacity-10 p-3">
                                <i class="fas fa-shipping-fast text-info fs-22"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quote Analysis Section -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title mb-0">Quote Performance</h5>
                    <div class="dropdown">
                        <a href="#" class="dropdown-toggle text-muted" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="#">Export as PDF</a></li>
                            <li><a class="dropdown-item" href="#">Export as Excel</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="#">Refresh</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div id="quote-status-chart" class="apex-charts" dir="ltr"></div>
                        </div>
                        <div class="col-md-6">
                            <div class="mt-3 mt-md-0">
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="avatar-xs">
                                            <span class="avatar-title rounded-circle bg-success bg-opacity-10">
                                                <i class="fas fa-check-circle text-success fs-16"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1">Won Quotes</h6>
                                        <p class="text-muted mb-0"><?php echo e($wonQuotes); ?> quotes · <?php echo e(number_format(($wonQuotes/$totalQuotes)*100, 1)); ?>%</p>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($wonQuotes); ?></h6>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="avatar-xs">
                                            <span class="avatar-title rounded-circle bg-danger bg-opacity-10">
                                                <i class="fas fa-times-circle text-danger fs-16"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1">Lost Quotes</h6>
                                        <p class="text-muted mb-0"><?php echo e($lostQuotes); ?> quotes · <?php echo e(number_format(($lostQuotes/$totalQuotes)*100, 1)); ?>%</p>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($lostQuotes); ?></h6>
                                    </div>
                                </div>

                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <div class="avatar-xs">
                                            <span class="avatar-title rounded-circle bg-warning bg-opacity-10">
                                                <i class="fas fa-clock text-warning fs-16"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1">Pending Quotes</h6>
                                        <p class="text-muted mb-0"><?php echo e($pendingQuotes); ?> quotes · <?php echo e(number_format(($pendingQuotes/$totalQuotes)*100, 1)); ?>%</p>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($pendingQuotes); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Win Rate Analysis</h5>
                </div>
                <div class="card-body text-center p-4">
                    <div class="mb-4">
                        <div class="win-rate-chart mx-auto">
                            <div id="win-rate-gauge" class="apex-charts" dir="ltr"></div>
                        </div>
                    </div>
                    <h3 class="mb-1"><?php echo e(number_format($winRate, 1)); ?>%</h3>
                    <p class="text-muted">Overall Win Rate</p>
                    <div class="mt-3">
                        <button class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-download me-1"></i> Export Report
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Profit Margin Section -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title mb-0">Financial Overview</h5>
                    <div class="dropdown">
                        <a href="#" class="dropdown-toggle text-muted" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="#">View Details</a></li>
                            <li><a class="dropdown-item" href="#">Compare Periods</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="p-2">
                                <h4 class="mb-1 text-primary">$<?php echo e(number_format($totalRevenue, 2)); ?></h4>
                                <p class="text-muted mb-0">Revenue</p>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-2">
                                <h4 class="mb-1 text-info">$<?php echo e(number_format($totalCost, 2)); ?></h4>
                                <p class="text-muted mb-0">Cost</p>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-2">
                                <h4 class="mb-1 text-success">$<?php echo e(number_format($totalProfit, 2)); ?></h4>
                                <p class="text-muted mb-0">Profit</p>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <div id="revenue-chart" class="apex-charts" dir="ltr"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title mb-0">Top Performing Quotes</h5>
                    <a href="#" class="text-muted">View All</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Quote No</th>
                                    <th>Profit Margin</th>
                                    <th>Profit Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $wonQuotesData->sortByDesc(function($quote) { 
                                    return ($quote->quoted_price - $quote->calculated_total_cost) / $quote->calculated_total_cost * 100; 
                                })->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $margin = $quote->calculated_total_cost > 0 ? 
                                        (($quote->quoted_price - $quote->calculated_total_cost) / $quote->calculated_total_cost) * 100 : 0;
                                    $profit = $quote->quoted_price - $quote->calculated_total_cost;
                                ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <div class="avatar-xs">
                                                    <span class="avatar-title bg-primary bg-opacity-10 rounded-circle text-primary">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <?php echo e($quote->quotation_number); ?>

                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-success bg-opacity-10 text-success">
                                            <i class="fas fa-chart-line me-1"></i> <?php echo e(number_format($margin, 1)); ?>%
                                        </span>
                                    </td>
                                    <td class="fw-semibold">$<?php echo e(number_format($profit, 2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body text-center p-4">
                    <div class="avatar-lg mx-auto mb-3">
                        <div class="avatar-title bg-success bg-opacity-10 rounded-circle">
                            <i class="fas fa-percentage text-success fs-24"></i>
                        </div>
                    </div>
                    <h4 class="mb-2"><?php echo e(number_format($avgMargin, 1)); ?>%</h4>
                    <p class="text-muted mb-3">Average Profit Margin</p>
                    <div class="d-flex gap-2 justify-content-center">
                        <button type="button" class="btn btn-primary btn-sm">View Details</button>
                        <button type="button" class="btn btn-outline-primary btn-sm">Export</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Shipment Performance Section -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="card-title mb-0">Order Status Overview</h5>
                    <div class="dropdown">
                        <a href="#" class="dropdown-toggle text-muted" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="#">Filter by Date</a></li>
                            <li><a class="dropdown-item" href="#">Export Data</a></li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-5">
                            <div id="order-status-chart" class="apex-charts" dir="ltr"></div>
                        </div>
                        <div class="col-md-7">
                            <div class="mt-3 mt-md-0">
                                <?php
                                    $statuses = [
                                        'delivered' => ['count' => $deliveredOrders, 'color' => 'success', 'icon' => 'check-circle'],
                                        'shipped' => ['count' => $shippedOrders, 'color' => 'info', 'icon' => 'shipping-fast'],
                                        'in_production' => ['count' => App\Models\OrderConfirmation::where('status', 'in_production')->count(), 'color' => 'warning', 'icon' => 'cogs'],
                                        'confirmed' => ['count' => App\Models\OrderConfirmation::where('status', 'confirmed')->count(), 'color' => 'primary', 'icon' => 'clipboard-check'],
                                    ];
                                ?>
                                
                                <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex align-items-center mb-4">
                                    <div class="flex-shrink-0">
                                        <div class="avatar-xs">
                                            <span class="avatar-title rounded-circle bg-<?php echo e($data['color']); ?> bg-opacity-10">
                                                <i class="fas fa-<?php echo e($data['icon']); ?> text-<?php echo e($data['color']); ?> fs-16"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1 text-capitalize"><?php echo e(str_replace('_', ' ', $status)); ?></h6>
                                        <p class="text-muted mb-0"><?php echo e($data['count']); ?> orders · <?php echo e(number_format(($data['count']/$totalOrders)*100, 1)); ?>%</p>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($data['count']); ?></h6>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <div class="avatar-xs">
                                            <span class="avatar-title rounded-circle bg-danger bg-opacity-10">
                                                <i class="fas fa-exclamation-triangle text-danger fs-16"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1">Overdue Orders</h6>
                                        <p class="text-muted mb-0"><?php echo e($overdueOrders); ?> orders · <?php echo e(number_format(($overdueOrders/$totalOrders)*100, 1)); ?>%</p>
                                    </div>
                                    <div>
                                        <h6 class="mb-0 text-danger"><?php echo e($overdueOrders); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Delivery Performance</h5>
                </div>
                <div class="card-body text-center p-4">
                    <div class="mb-4">
                        <div class="delivery-chart mx-auto">
                            <div id="delivery-gauge" class="apex-charts" dir="ltr"></div>
                        </div>
                    </div>
                    <h3 class="mb-1"><?php echo e(number_format($onTimeRate, 1)); ?>%</h3>
                    <p class="text-muted">On-Time Delivery Rate</p>
                    <div class="mt-3">
                        <button class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-chart-bar me-1"></i> View Details
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
.card-animate {
    transition: all 0.3s ease;
}
.card-animate:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}
.win-rate-chart, .delivery-chart {
    max-width: 200px;
}
.avatar-sm {
    width: 48px;
    height: 48px;
}
.avatar-xs {
    width: 32px;
    height: 32px;
}
.avatar-lg {
    width: 64px;
    height: 64px;
}
.apex-charts {
    min-height: 300px !important;
}
</style>

<!-- ApexCharts Script for Visualizations -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Quote Status Chart
    var quoteStatusChart = new ApexCharts(document.querySelector("#quote-status-chart"), {
        series: [<?php echo e($wonQuotes); ?>, <?php echo e($lostQuotes); ?>, <?php echo e($pendingQuotes); ?>],
        chart: {
            type: 'donut',
            height: 300,
        },
        labels: ['Won', 'Lost', 'Pending'],
        colors: ['#0acf97', '#fa5c7c', '#ffbc00'],
        legend: {
            show: false
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '70%',
                }
            }
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    height: 250
                }
            }
        }]
    });
    quoteStatusChart.render();

    // Win Rate Gauge
    var winRateGauge = new ApexCharts(document.querySelector("#win-rate-gauge"), {
        series: [<?php echo e($winRate); ?>],
        chart: {
            height: 200,
            type: 'radialBar',
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: '70%',
                },
                dataLabels: {
                    show: false
                }
            },
        },
        colors: ['#0acf97'],
        labels: ['Win Rate'],
    });
    winRateGauge.render();

    // Revenue Chart
    var revenueChart = new ApexCharts(document.querySelector("#revenue-chart"), {
        series: [{
            name: 'Revenue',
            data: [<?php echo e($totalRevenue); ?>]
        }, {
            name: 'Cost',
            data: [<?php echo e($totalCost); ?>]
        }, {
            name: 'Profit',
            data: [<?php echo e($totalProfit); ?>]
        }],
        chart: {
            type: 'bar',
            height: 300,
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
            },
        },
        colors: ['#727cf5', '#39afd1', '#0acf97'],
        dataLabels: {
            enabled: false
        },
        xaxis: {
            categories: ['Current Period'],
        },
        yaxis: {
            title: {
                text: 'Amount ($)'
            }
        },
    });
    revenueChart.render();

    // Order Status Chart
    var orderStatusChart = new ApexCharts(document.querySelector("#order-status-chart"), {
        series: [<?php echo e($deliveredOrders); ?>, <?php echo e($shippedOrders); ?>, <?php echo e(App\Models\OrderConfirmation::where('status', 'in_production')->count()); ?>, <?php echo e(App\Models\OrderConfirmation::where('status', 'confirmed')->count()); ?>],
        chart: {
            type: 'pie',
            height: 300,
        },
        labels: ['Delivered', 'Shipped', 'In Production', 'Confirmed'],
        colors: ['#0acf97', '#39afd1', '#ffbc00', '#727cf5'],
        legend: {
            show: false
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    height: 250
                }
            }
        }]
    });
    orderStatusChart.render();

    // Delivery Gauge
    var deliveryGauge = new ApexCharts(document.querySelector("#delivery-gauge"), {
        series: [<?php echo e($onTimeRate); ?>],
        chart: {
            height: 200,
            type: 'radialBar',
        },
        plotOptions: {
            radialBar: {
                hollow: {
                    size: '70%',
                },
                dataLabels: {
                    show: false
                }
            },
        },
        colors: ['#727cf5'],
        labels: ['On-Time Delivery'],
    });
    deliveryGauge.render();
});
</script><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/reports/dashboard.blade.php ENDPATH**/ ?>