<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Advance Payments'); ?>

    <a href="<?php echo e(route('admin.advance-payments.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Log Advance Payment
    </a>
    <a href="<?php echo e(route('admin.payment.ledger')); ?>" class="btn btn-info">
        <i class="fas fa-book me-1"></i> View Ledger
    </a>

<div class="card mt-5">
    <div class="card-header">
        <h5 class="card-title mb-0">Advance Payment Tracker</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Reference</th>
                        <th>Buyer</th>
                        <th>Order</th>
                        <th>Amount</th>
                        <th>Payment Date</th>
                        <th>Method</th>
                        <th>Status</th>
                        <th>Remaining</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $advancePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($payment->reference_number); ?></td>
                        <td><?php echo e($payment->buyer->contact_person); ?></td>
                        <td><?php echo e($payment->orderConfirmation->order_number ?? 'N/A'); ?></td>
                        <td>$<?php echo e(number_format($payment->amount, 2)); ?></td>
                        <td><?php echo e($payment->payment_date->format('M d, Y')); ?></td>
                        <td>
                            <span class="badge bg-info text-dark text-uppercase">
                                <?php echo e($payment->payment_method); ?>

                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($payment->status_badge_color); ?> status-badge">
                                <?php echo e(ucfirst($payment->status)); ?>

                            </span>
                        </td>
                        <td>
                            <span class="fw-bold text-<?php echo e($payment->remaining_amount > 0 ? 'success' : 'secondary'); ?>">
                                $<?php echo e(number_format($payment->remaining_amount, 2)); ?>

                            </span>
                        </td>
                        <td class="table-actions">
                            <a href="<?php echo e(route('admin.advance-payments.show', $payment)); ?>" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.advance-payments.edit', $payment)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <?php if($payment->canAllocate()): ?>
                            <a href="<?php echo e(route('admin.payment-allocations.create')); ?>?advance_payment_id=<?php echo e($payment->id); ?>" 
                               class="btn btn-sm btn-success" title="Allocate to Factory">
                                <i class="fas fa-share-alt"></i>
                            </a>
                            <?php endif; ?>
                            <form action="<?php echo e(route('admin.advance-payments.destroy', $payment)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            <?php echo e($advancePayments->links()); ?>

        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/advance-payments/index.blade.php ENDPATH**/ ?>