<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Bank Invoice Details'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.bank-invoices.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Invoices
    </a>
    <a href="<?php echo e(route('admin.bank-invoices.edit', $bankInvoice)); ?>" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
    <a href="<?php echo e(route('admin.bank-invoices.export-pdf', $bankInvoice)); ?>" class="btn btn-info" target="_blank">
        <i class="fas fa-download me-1"></i> Export PDF
    </a>
    <?php if($bankInvoice->status === 'draft'): ?>
    <form action="<?php echo e(route('admin.bank-invoices.mark-sent', $bankInvoice)); ?>" method="POST" class="d-inline">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
        </button>
    </form>
    <?php endif; ?>
    <?php if($bankInvoice->status === 'sent'): ?>
    <form action="<?php echo e(route('admin.bank-invoices.mark-paid', $bankInvoice)); ?>" method="POST" class="d-inline">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn btn-success">
            <i class="fas fa-check me-1"></i> Mark as Paid
        </button>
    </form>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Invoice Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Invoice Number</th>
                                <td><?php echo e($bankInvoice->invoice_number); ?></td>
                            </tr>
                            <tr>
                                <th>Buyer</th>
                                <td><?php echo e($bankInvoice->buyer->contact_person); ?></td>
                            </tr>
                            <tr>
                                <th>Order Confirmation</th>
                                <td><?php echo e($bankInvoice->orderConfirmation->order_number); ?></td>
                            </tr>
                            <tr>
                                <th>Invoice Amount</th>
                                <td class="fw-bold">$<?php echo e(number_format($bankInvoice->amount, 2)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Invoice Date</th>
                                <td><?php echo e($bankInvoice->invoice_date->format('M d, Y')); ?></td>
                            </tr>
                            <tr>
                                <th>Due Date</th>
                                <td class="<?php echo e($bankInvoice->is_overdue ? 'text-danger fw-bold' : ''); ?>">
                                    <?php echo e($bankInvoice->due_date->format('M d, Y')); ?>

                                    <?php if($bankInvoice->is_overdue): ?>
                                    <br><small class="text-danger">(Overdue)</small>
                                    <?php else: ?>
                                    <br><small class="text-muted">(<?php echo e($bankInvoice->days_until_due); ?> days remaining)</small>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Tax Amount</th>
                                <td>$<?php echo e(number_format($bankInvoice->tax_amount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th>Total Amount</th>
                                <td class="fw-bold text-success">$<?php echo e(number_format($bankInvoice->total_amount, 2)); ?></td>
                                
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Status</th>
                                <td>
                                    <span class="badge bg-<?php echo e($bankInvoice->status_badge_color); ?> text-white">
                                        <?php echo e(ucfirst($bankInvoice->status)); ?>

                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Created By</th>
                                <td><?php echo e($bankInvoice->creator->name); ?></td>
                            </tr>
                            <tr>
                                <th>Created At</th>
                                <td><?php echo e($bankInvoice->created_at->format('M d, Y H:i')); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description</label>
                            <div class="border p-3 bg-light rounded">
                                <?php echo e($bankInvoice->description); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <?php if($bankInvoice->bank_remarks): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Bank Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                <?php echo e($bankInvoice->bank_remarks); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <h6><?php echo e($bankInvoice->buyer->company_name); ?></h6>
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> <?php echo e($bankInvoice->buyer->contact_person); ?></li>
                    <li><strong>Email:</strong> <?php echo e($bankInvoice->buyer->email); ?></li>
                    <li><strong>Phone:</strong> <?php echo e($bankInvoice->buyer->phone); ?></li>
                    <li><strong>Address:</strong> <?php echo e($bankInvoice->buyer->address); ?></li>
                    <li><strong>Country:</strong> <?php echo e($bankInvoice->buyer->country); ?></li>
                </ul>
                
                <?php if($bankInvoice->buyer->bank): ?>
                <hr>
                <h6>Bank Details</h6>
                <ul class="list-unstyled">
                    <li><strong>Bank:</strong> <?php echo e($bankInvoice->buyer->bank->bank_name); ?></li>
                    <li><strong>Account:</strong> <?php echo e($bankInvoice->buyer->bank->account_no); ?></li>
                    <li><strong>SWIFT:</strong> <?php echo e($bankInvoice->buyer->bank->swift); ?></li>
                </ul>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Order Information</h6>
            </div>
            <div class="card-body">
                <h6><?php echo e($bankInvoice->orderConfirmation->order_number); ?></h6>
                <ul class="list-unstyled">
                    <li><strong>Quantity:</strong> <?php echo e(number_format($bankInvoice->orderConfirmation->confirmed_quantity)); ?></li>
                    <li><strong>Price:</strong> $<?php echo e(number_format($bankInvoice->orderConfirmation->confirmed_price, 2)); ?></li>
                    <li><strong>Total Value:</strong> $<?php echo e(number_format($bankInvoice->orderConfirmation->total_value, 2)); ?></li>
                    <li><strong>Delivery:</strong> <?php echo e($bankInvoice->orderConfirmation->formatted_delivery_date); ?></li>
                    <li><strong>Status:</strong> 
                        <span class="badge bg-<?php echo e($bankInvoice->orderConfirmation->status_badge_color); ?> text-white">
                            <?php echo e(ucfirst($bankInvoice->orderConfirmation->status)); ?>

                        </span>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.bank-invoices.export-pdf', $bankInvoice)); ?>" class="btn btn-outline-primary mb-4" target="_blank">
                        <i class="fas fa-file-pdf me-1"></i> Download PDF
                    </a>
                    <?php if($bankInvoice->status === 'draft'): ?>
                    <form action="<?php echo e(route('admin.bank-invoices.mark-sent', $bankInvoice)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-paper-plane me-1"></i> Mark as Sent
                        </button>
                    </form>
                    <?php endif; ?>
                    <?php if($bankInvoice->status === 'sent'): ?>
                    <form action="<?php echo e(route('admin.bank-invoices.mark-paid', $bankInvoice)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-check me-1"></i> Mark as Paid
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/bank-invoices/show.blade.php ENDPATH**/ ?>