<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Packing List - <?php echo e($order->order_number ?? 'N/A'); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; }
        .section { margin-bottom: 15px; }
        .section-title { background: #f8f9fa; padding: 5px; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f8f9fa; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
    </style>
</head>
<body>
    <div class="header">
        <h2>PACKING LIST</h2>
        <p>Order No: <?php echo e($order->order_number ?? 'N/A'); ?></p>
        <p>Date: <?php echo e(now()->format('M d, Y')); ?></p>
    </div>

    <div class="section">
        <div class="section-title">Order Information</div>
        <table>
            <tr>
                <td width="25%"><strong>Order Number:</strong></td>
                <td><?php echo e($order->order_number ?? 'N/A'); ?></td>
                <td width="25%"><strong>Customer PO:</strong></td>
                <td><?php echo e($order->customer_po_number ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <td><strong>Total Quantity:</strong></td>
                <td><?php echo e($order->confirmed_quantity ?? 'N/A'); ?> units</td>
                <td><strong>Delivery Date:</strong></td>
                <td><?php echo e($order->delivery_date ? $order->delivery_date->format('M d, Y') : 'N/A'); ?></td>
            </tr>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Packing Details</div>
        <table>
            <thead>
                <tr>
                    <th>Carton No</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Weight (kg)</th>
                    <th>Dimensions (cm)</th>
                </tr>
            </thead>
            <tbody>
                <?php for($i = 1; $i <= 5; $i++): ?>
                <tr>
                    <td class="text-center"><?php echo e($i); ?></td>
                    <td>Carton <?php echo e($i); ?> - Order <?php echo e($order->order_number ?? 'N/A'); ?></td>
                    <td class="text-center"><?php echo e(floor($order->confirmed_quantity / 5)); ?></td>
                    <td class="text-center"><?php echo e(rand(10, 25)); ?></td>
                    <td class="text-center">40x30x30</td>
                </tr>
                <?php endfor; ?>
                <tr>
                    <td colspan="2" class="text-right"><strong>Total:</strong></td>
                    <td class="text-center"><strong><?php echo e($order->confirmed_quantity ?? 'N/A'); ?></strong></td>
                    <td class="text-center"><strong>~<?php echo e(rand(80, 120)); ?> kg</strong></td>
                    <td></td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="section">
        <div class="section-title">Shipping Marks</div>
        <p>Order No: <?php echo e($order->order_number ?? 'N/A'); ?></p>
        <p>Carton No: 1-<?php echo e(ceil($order->confirmed_quantity / floor($order->confirmed_quantity / 5))); ?></p>
        <p>Made in: [Country of Origin]</p>
    </div>

    <?php if($include_terms): ?>
    <div class="section">
        <div class="section-title">Packing Instructions</div>
        <p>1. All items must be properly packed to prevent damage during transit.<br>
           2. Each carton must be clearly marked with order number and carton number.<br>
           3. Fragile items must be marked accordingly.<br>
           4. Maximum weight per carton should not exceed 25kg.</p>
    </div>
    <?php endif; ?>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/templates/packing_list.blade.php ENDPATH**/ ?>