<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', $buyer->company_name . ' - Ledger Details'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.payment-ledger.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Ledger
    </a>
    <a href="<?php echo e(route('admin.payment-ledger.buyer-report', $buyer)); ?>" class="btn btn-info" target="_blank">
        <i class="fas fa-download me-1"></i> Export PDF
    </a>
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Ledger Summary</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Buyer:</strong> <?php echo e($buyer->company_name); ?>

                </div>
                <div class="mb-2">
                    <strong>Total Payments In:</strong>
                    <span class="float-end text-success fw-bold">$<?php echo e(number_format($ledger->total_in, 2)); ?></span>
                </div>
                <div class="mb-2">
                    <strong>Total Allocations Out:</strong>
                    <span class="float-end text-danger fw-bold">$<?php echo e(number_format($ledger->total_out, 2)); ?></span>
                </div>
                <div class="mb-2">
                    <strong>Current Balance:</strong>
                    <span class="float-end fw-bold <?php echo e($ledger->current_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                        $<?php echo e(number_format($ledger->current_balance, 2)); ?>

                    </span>
                </div>
                <div class="mt-3">
                    <small class="text-muted">Last Updated: <?php echo e($ledger->last_updated->format('M d, Y H:i')); ?></small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Buyer Information</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li><strong>Contact:</strong> <?php echo e($buyer->contact_person); ?></li>
                    <li><strong>Email:</strong> <?php echo e($buyer->email); ?></li>
                    <li><strong>Phone:</strong> <?php echo e($buyer->phone); ?></li>
                    <li><strong>Address:</strong> <?php echo e($buyer->address); ?></li>
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Payment History</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Allocated</th>
                                <th>Balance</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $advancePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($payment->payment_date->format('M d, Y')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.advance-payments.show', $payment)); ?>" class="text-decoration-none">
                                        <?php echo e($payment->reference_number); ?>

                                    </a>
                                </td>
                                <td><?php echo e($payment->orderConfirmation->order_number ?? 'N/A'); ?></td>
                                <td class="text-success">$<?php echo e(number_format($payment->amount, 2)); ?></td>
                                <td class="text-danger">$<?php echo e(number_format($payment->allocated_amount, 2)); ?></td>
                                <td class="fw-bold <?php echo e($payment->remaining_amount > 0 ? 'text-success' : 'text-secondary'); ?>">
                                    $<?php echo e(number_format($payment->remaining_amount, 2)); ?>

                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($payment->status_badge_color); ?> status-badge">
                                        <?php echo e(ucfirst($payment->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.advance-payments.show', $payment)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Allocation History</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Reference</th>
                                <th>Factory</th>
                                <th>Order</th>
                                <th>Amount</th>
                                <th>Purpose</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($allocation->allocation_date->format('M d, Y')); ?></td>
                                <td><?php echo e($allocation->reference_number); ?></td>
                                <td><?php echo e($allocation->factory->name); ?></td>
                                <td><?php echo e($allocation->orderConfirmation->order_number); ?></td>
                                <td class="text-danger">$<?php echo e(number_format($allocation->amount, 2)); ?></td>
                                <td><?php echo e(Str::limit($allocation->purpose, 50)); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.payment-allocations.show', $allocation)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                            <?php if($allocations->isEmpty()): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">No allocations found</td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/ledger/show.blade.php ENDPATH**/ ?>