<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 

<div class="container">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1>Inquiries</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="<?php echo e(route('admin.inquiries.create')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> Create New Inquiry</a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-dark text-center">
                        <tr>
                            <th>Customer Name</th>
                            <th>PO Number</th>
                            <th>Style Number</th>
                            <th>Item Description</th>
                            <th>Order Quantity</th>
                            <th>Shipment Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $inquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($inquiry->buyer->company_name); ?></td>
                                <td><?php echo e($inquiry->purchase_order_no); ?></td>
                                <td><?php echo e($inquiry->style_number); ?></td>
                                <td><?php echo e($inquiry->itemDescription->name); ?></td>
                                <td><?php echo e($inquiry->order_quantity); ?></td>
                                <td><?php echo e($inquiry->shipment_date->format(' F j, Y')); ?></td>
                            
                                <td>
                            
                                   
      <div class="dropdown " >
                                <button class="btn btn-primary btn-sm dropdown-toggle" type="button" id="actionDropdown<?php echo e($inquiry->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                    Actions
                                </button>
                                <ul class="dropdown-menu p-3" style="z-index: 999!important;" aria-labelledby="actionDropdown<?php echo e($inquiry->id); ?>">
                                   <i class="fas fa-eye"></i> 

   <a href="<?php echo e(route('admin.inquiries.show', $inquiry->id)); ?>" class="text-dark mb-2">View</a>
                                    </li>
                                    <li>

    <a href="<?php echo e(route('admin.inquiries.edit', $inquiry->id)); ?>" class="text-dark mb-2"><i class="fas fa-edit"></i> Update</a>

    <a href="<?php echo e(route('admin.quotations.create', ['inquiry_id' => $inquiry->id])); ?>">
  <i class="fas fa-calculator"></i> Quotation Generator
</a>
                        
                                    </li>
                                    <li>
                                   <form action="<?php echo e(route('admin.inquiries.destroy', $inquiry->id)); ?>" method="POST" style="display:inline-block;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="" onclick="return confirm('Are you sure you want to delete this inquiry?')"><i class="fas fa-trash"></i> Remove</button>
                                    </form>
                                    </li>
                                </ul>
                            </div>






                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center">No inquiries found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php echo e($inquiries->links()); ?> 
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/inquiries/index.blade.php ENDPATH**/ ?>