<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice <?php echo e($bankInvoice->invoice_number); ?></title>
    <style>
        body { 
            font-family: DejaVu Sans, sans-serif; 
            font-size: 12px; 
            line-height: 1.4;
        }
        .header { 
            text-align: center; 
            margin-bottom: 30px; 
            border-bottom: 2px solid #333; 
            padding-bottom: 20px; 
        }
        .company-name { 
            font-size: 24px; 
            font-weight: bold; 
            margin-bottom: 5px; 
            color: #2c3e50;
        }
        .invoice-title { 
            font-size: 20px; 
            margin: 20px 0; 
            color: #34495e;
        }
        .details-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        .details-table td { 
            padding: 8px; 
            border: 1px solid #ddd; 
        }
        .details-table .label { 
            font-weight: bold; 
            background: #f8f9fa; 
            width: 30%; 
        }
        .amount-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        .amount-table th, .amount-table td { 
            padding: 10px; 
            border: 1px solid #333; 
            text-align: right; 
        }
        .amount-table th { 
            background: #333; 
            color: white; 
            text-align: left; 
        }
        .footer { 
            margin-top: 50px; 
            padding-top: 20px; 
            border-top: 1px solid #ddd; 
        }
        .signature { 
            margin-top: 50px; 
        }
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: bold;
        }
        .status-draft { background: #6c757d; color: white; }
        .status-sent { background: #007bff; color: white; }
        .status-paid { background: #28a745; color: white; }
        .status-cancelled { background: #dc3545; color: white; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">Textile Export Company</div>
        <div>123 Textile Street, Industrial Area, City - 123456</div>
        <div>Phone: +91-1234567890 | Email: info@textileexport.com</div>
    </div>

    <div class="invoice-title">COMMERCIAL INVOICE</div>

    <table class="details-table">
        <tr>
            <td class="label">Invoice Number:</td>
            <td><?php echo e($bankInvoice->invoice_number); ?></td>
            <td class="label">Invoice Date:</td>
            <td><?php echo e($bankInvoice->invoice_date->format('d/m/Y')); ?></td>
        </tr>
        <tr>
            <td class="label">Buyer:</td>
            <td colspan="3"><?php echo e($bankInvoice->buyer->contact_person); ?></td>
        </tr>
        <tr>
            <td class="label">Order Number:</td>
            <td><?php echo e($bankInvoice->orderConfirmation->order_number); ?></td>
            <td class="label">Due Date:</td>
            <td><?php echo e($bankInvoice->due_date->format('d/m/Y')); ?></td>
        </tr>
        <tr>
            <td class="label">Status:</td>
            <td>
                <span class="status-badge status-<?php echo e($bankInvoice->status); ?>">
                    <?php echo e(strtoupper($bankInvoice->status)); ?>

                </span>
            </td>
            <td class="label">Created By:</td>
            <td><?php echo e($bankInvoice->creator->name); ?></td>
        </tr>
        <tr>
            <td class="label">Description:</td>
            <td colspan="3"><?php echo e($bankInvoice->description); ?></td>
        </tr>
    </table>

    <table class="amount-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Amount ($)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Invoice Amount</td>
                <td><?php echo e(number_format($bankInvoice->amount, 2)); ?></td>
            </tr>
            <?php if($bankInvoice->tax_amount > 0): ?>
            <tr>
                <td>Tax Amount</td>
                <td><?php echo e(number_format($bankInvoice->tax_amount, 2)); ?></td>
            </tr>
            <?php endif; ?>
            <tr style="font-weight: bold; font-size: 14px;">
                <td>TOTAL AMOUNT</td>
                <td><?php echo e(number_format($bankInvoice->total_amount, 2)); ?></td>
            </tr>
        </tbody>
    </table>

    <?php if($bankInvoice->bank_remarks): ?>
    <div style="margin: 20px 0;">
        <strong>Bank Remarks:</strong><br>
        <?php echo e($bankInvoice->bank_remarks); ?>

    </div>
    <?php endif; ?>

    <div class="footer">
        <div style="float: left; width: 50%;">
            <strong>Buyer Information:</strong><br>
            <?php echo e($bankInvoice->buyer->company_name); ?><br>
            <?php echo e($bankInvoice->buyer->address); ?><br>
            <?php echo e($bankInvoice->buyer->country); ?><br>
            Contact: <?php echo e($bankInvoice->buyer->contact_person); ?><br>
            Email: <?php echo e($bankInvoice->buyer->email); ?><br>
            Phone: <?php echo e($bankInvoice->buyer->phone); ?>

        </div>
        
        <div class="signature" style="float: right; text-align: center;">
            <div style="border-top: 1px solid #333; width: 200px; margin-bottom: 5px;"></div>
            <div>Authorized Signature</div>
            <div>Textile Export Company</div>
        </div>
        <div style="clear: both;"></div>
    </div>

    <div style="margin-top: 30px; text-align: center; font-size: 10px; color: #666;">
        Generated on: <?php echo e(date('d/m/Y H:i')); ?> | Page 1 of 1
    </div>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/bank-invoices/export/pdf.blade.php ENDPATH**/ ?>