<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Analytics & Reports</li>
                    </ol>
                </div>
                <h4 class="page-title">Reports & Analytics Dashboard</h4>
            </div>
        </div>
    </div>

    <!-- Quick Stats Row -->
    <div class="row">
        <!-- Quote Win/Loss -->
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <p class="fw-medium text-muted mb-0">Quote Win Rate</p>
                            <h2 class="mt-2 ff-secondary fw-bold"><span><?php echo e($quoteStats['win_rate']); ?>%</span></h2>
                            <p class="mb-0 text-muted">
                                <span class="badge bg-success me-1"><i class="fas fa-arrow-up"></i></span>
                                <?php echo e($quoteStats['won_quotations']); ?> won / <?php echo e($quoteStats['total_quotations']); ?> total
                            </p>
                        </div>
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-primary rounded-circle fs-2">
                                <i class="fas fa-chart-line"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Profit Margin -->
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <p class="fw-medium text-muted mb-0">Avg Profit Margin</p>
                            <h2 class="mt-2 ff-secondary fw-bold"><span><?php echo e($profitStats['average_margin']); ?>%</span></h2>
                            <p class="mb-0 text-muted">
                                <span class="text-success fw-semibold">$<?php echo e(number_format($profitStats['total_profit'], 2)); ?></span> total profit
                            </p>
                        </div>
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-success rounded-circle fs-2">
                                <i class="fas fa-dollar-sign"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Shipment Performance -->
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <p class="fw-medium text-muted mb-0">On-Time Delivery</p>
                            <h2 class="mt-2 ff-secondary fw-bold"><span><?php echo e($shipmentStats['on_time_rate']); ?>%</span></h2>
                            <p class="mb-0 text-muted">
                                <span class="badge bg-<?php echo e($shipmentStats['overdue_orders'] > 0 ? 'danger' : 'success'); ?> me-1">
                                    <?php echo e($shipmentStats['overdue_orders']); ?> overdue
                                </span>
                            </p>
                        </div>
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-info rounded-circle fs-2">
                                <i class="fas fa-shipping-fast"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Revenue -->
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <p class="fw-medium text-muted mb-0">Total Revenue</p>
                            <h2 class="mt-2 ff-secondary fw-bold">$<span><?php echo e(number_format($profitStats['total_revenue'], 0)); ?></span></h2>
                            <p class="mb-0 text-muted">
                                <span class="text-muted">From <?php echo e($quoteStats['won_quotations']); ?> won quotes</span>
                            </p>
                        </div>
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-warning rounded-circle fs-2">
                                <i class="fas fa-chart-pie"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts & Detailed Analytics Row -->
    <div class="row">
        <!-- Quote Analysis Chart -->
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Quote Performance</h4>
                    <div class="flex-shrink-0">
                        <a href="<?php echo e(route('admin.analytics.quote-analysis')); ?>" class="btn btn-soft-primary btn-sm">
                            View Details <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div id="quote-chart" class="apex-charts" dir="ltr"></div>
                </div>
            </div>
        </div>

        <!-- Profit Margin Distribution -->
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Profit Margin Distribution</h4>
                    <div class="flex-shrink-0">
                        <a href="<?php echo e(route('admin.analytics.profit-margin')); ?>" class="btn btn-soft-success btn-sm">
                            View Details <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div id="profit-chart" class="apex-charts" dir="ltr"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Analytics & Recent Activity -->
    <div class="row">
        <!-- Shipment Performance -->
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Shipment Performance</h4>
                    <div class="flex-shrink-0">
                        <a href="<?php echo e(route('admin.analytics.shipment-performance')); ?>" class="btn btn-soft-info btn-sm">
                            View Details <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="p-3 border border-dashed border-start-0">
                                <h5 class="mb-1"><?php echo e($shipmentStats['delivered_orders']); ?></h5>
                                <p class="text-muted mb-0">Delivered</p>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-3 border border-dashed border-start-0">
                                <h5 class="mb-1"><?php echo e($shipmentStats['shipped_orders']); ?></h5>
                                <p class="text-muted mb-0">In Transit</p>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-3 border border-dashed border-start-0 border-end-0">
                                <h5 class="mb-1"><?php echo e($shipmentStats['overdue_orders']); ?></h5>
                                <p class="text-muted mb-0">Overdue</p>
                            </div>
                        </div>
                    </div>
                    <div id="shipment-chart" class="apex-charts mt-3" dir="ltr"></div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Recent Activity</h4>
                </div>
                <div class="card-body">
                    <div class="simplebar-wrapper">
                        <div data-simplebar style="max-height: 335px;">
                            <!-- Recent Quotes -->
                            <h6 class="text-uppercase fw-semibold mt-0 mb-3">Recent Quotes</h6>
                            <?php $__currentLoopData = $recentActivity['recent_quotes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-start mb-3">
                                <div class="flex-shrink-0">
                                    <div class="avatar-xs">
                                        <span class="avatar-title bg-soft-<?php echo e($quote->status_badge_color); ?> text-<?php echo e($quote->status_badge_color); ?> rounded-circle">
                                            <i class="fas fa-file-invoice"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1 fw-semibold"><?php echo e($quote->quotation_number); ?></h6>
                                    <p class="text-muted mb-0">
                                        <?php echo e($quote->inquiry->buyer->company_name ?? 'N/A'); ?> - 
                                        <span class="badge bg-<?php echo e($quote->status_badge_color); ?>"><?php echo e($quote->status_label); ?></span>
                                    </p>
                                    <small class="text-muted"><?php echo e($quote->created_at->diffForHumans()); ?></small>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <!-- Recent Orders -->
                            <h6 class="text-uppercase fw-semibold mt-4 mb-3">Recent Orders</h6>
                            <?php $__currentLoopData = $recentActivity['recent_orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-start mb-3">
                                <div class="flex-shrink-0">
                                    <div class="avatar-xs">
                                        <span class="avatar-title bg-soft-<?php echo e($order->status_badge_color); ?> text-<?php echo e($order->status_badge_color); ?> rounded-circle">
                                            <i class="fas fa-shopping-cart"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1 fw-semibold"><?php echo e($order->order_number); ?></h6>
                                    <p class="text-muted mb-0">
                                        $<?php echo e(number_format($order->total_value, 2)); ?> - 
                                        <span class="badge bg-<?php echo e($order->status_badge_color); ?>"><?php echo e(ucfirst($order->status)); ?></span>
                                    </p>
                                    <small class="text-muted"><?php echo e($order->created_at->diffForHumans()); ?></small>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-auto">
                            <a href="<?php echo e(route('admin.analytics.quote-analysis')); ?>" class="btn btn-primary mx-2">
                                <i class="fas fa-chart-bar me-2"></i>Quote Analysis
                            </a>
                            <a href="<?php echo e(route('admin.analytics.profit-margin')); ?>" class="btn btn-success mx-2">
                                <i class="fas fa-dollar-sign me-2"></i>Profit Margins
                            </a>
                            <a href="<?php echo e(route('admin.analytics.shipment-performance')); ?>" class="btn btn-info mx-2">
                                <i class="fas fa-shipping-fast me-2"></i>Shipment Performance
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Apex Charts -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Quote Performance Chart
    var quoteChartOptions = {
        series: [{
            name: 'Total Quotes',
            data: [<?php echo e($quoteStats['monthly_trend']->pluck('total')->join(', ')); ?>]
        }, {
            name: 'Won Quotes',
            data: [<?php echo e($quoteStats['monthly_trend']->pluck('won')->join(', ')); ?>]
        }],
        chart: {
            type: 'bar',
            height: 350,
            toolbar: { show: false }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
                endingShape: 'rounded'
            },
        },
        dataLabels: { enabled: false },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        colors: ['#727cf5', '#0acf97'],
        xaxis: {
            categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'].slice(-<?php echo e($quoteStats['monthly_trend']->count()); ?>),
        },
        yaxis: { title: { text: 'Number of Quotes' } },
        fill: { opacity: 1 },
        tooltip: {
            y: {
                formatter: function (val) {
                    return val + " quotes"
                }
            }
        }
    };

    var quoteChart = new ApexCharts(document.querySelector("#quote-chart"), quoteChartOptions);
    quoteChart.render();

    // Profit Margin Distribution Chart
    var profitChartOptions = {
        series: [<?php echo e(implode(', ', array_values($profitStats['margin_distribution']))); ?>],
        chart: {
            type: 'donut',
            height: 350,
        },
        labels: <?php echo json_encode(array_keys($profitStats['margin_distribution'])); ?>,
        colors: ['#727cf5', '#0acf97', '#fa5c7c', '#ffbc00'],
        legend: {
            position: 'bottom'
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '70%',
                }
            }
        }
    };

    var profitChart = new ApexCharts(document.querySelector("#profit-chart"), profitChartOptions);
    profitChart.render();

    // Shipment Performance Chart
    var shipmentChartOptions = {
        series: [{
            name: 'Orders',
            data: [<?php echo e($shipmentStats['monthly_performance']->pluck('total_orders')->join(', ')); ?>]
        }],
        chart: {
            type: 'line',
            height: 200,
            toolbar: { show: false }
        },
        colors: ['#39afd1'],
        stroke: {
            width: 3,
            curve: 'smooth'
        },
        markers: {
            size: 4,
            strokeWidth: 0,
            hover: { size: 7 }
        },
        xaxis: {
            categories: <?php echo json_encode($shipmentStats['monthly_performance']->map(function($item) { 
                return date('M Y', strtotime($item->year . '-' . $item->month . '-01')); 
            })); ?>

        },
        grid: {
            borderColor: '#f1f3fa',
            padding: { bottom: 5 }
        }
    };

    var shipmentChart = new ApexCharts(document.querySelector("#shipment-chart"), shipmentChartOptions);
    shipmentChart.render();
});
</script>

<style>
.card-animate {
    transition: all 0.3s ease;
}
.card-animate:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}
.avatar-title {
    display: flex;
    align-items: center;
    justify-content: center;
}
</style><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/analytics/dashboard.blade.php ENDPATH**/ ?>