<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-6">
            <h1><i class="fas fa-clipboard-check me-2"></i>Order Confirmations</h1>
        </div>
        <div class="col-md-6 text-right">
            <a href="<?php echo e(route('admin.quotations.index')); ?>?status=won" class="btn btn-primary">
                <i class="fas fa-plus me-1"></i>Create New Order (From Won Quotations)
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Status Dashboard Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['pending']); ?></h4>
                    <small>Pending</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['confirmed']); ?></h4>
                    <small>Confirmed</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['in_production']); ?></h4>
                    <small>In Production</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-info text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['shipped']); ?></h4>
                    <small>Shipped</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['delivered']); ?></h4>
                    <small>Delivered</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-danger text-white">
                <div class="card-body text-center">
                    <h4><?php echo e($statusCounts['overdue']); ?></h4>
                    <small>Overdue</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.order-confirmations.index')); ?>" class="row g-3">
                <div class="col-md-3">
                    <label for="status" class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                        <option value="in_production" <?php echo e(request('status') == 'in_production' ? 'selected' : ''); ?>>In Production</option>
                        <option value="shipped" <?php echo e(request('status') == 'shipped' ? 'selected' : ''); ?>>Shipped</option>
                        <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                        <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" name="search" id="search" class="form-control" 
                           placeholder="Order number, PO number..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="delivery_from" class="form-label">Delivery From</label>
                    <input type="date" name="delivery_from" id="delivery_from" class="form-control" 
                           value="<?php echo e(request('delivery_from')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="delivery_to" class="form-label">Delivery To</label>
                    <input type="date" name="delivery_to" id="delivery_to" class="form-control" 
                           value="<?php echo e(request('delivery_to')); ?>">
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-search me-1"></i>Filter
                    </button>
                    <a href="<?php echo e(route('admin.order-confirmations.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-times me-1"></i>Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-dark">
                        <tr>
                            <th>Order Number</th>
                            <th>Quotation</th>
                            <th>Customer</th>
                            <th>Customer Email</th>

                            <th>Item</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Total Value</th>
                            <th>Delivery Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orderConfirmations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e($order->is_overdue ? 'table-warning' : ''); ?>">
                                <td>
                                    <strong><?php echo e($order->order_number); ?></strong>
                                    <?php if($order->customer_po_number): ?>
                                        <br><small class="text-muted">PO: <?php echo e($order->customer_po_number); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.quotations.show', $order->quotation_id)); ?>" class="text-decoration-none">
                                        <?php echo e($order->quotation->quotation_number); ?>

                                    </a>
                                </td>
                                <td><?php echo e($order->quotation->inquiry->buyer->company_name ?? 'N/A'); ?></td>

                                <td><?php echo e($order->quotation->inquiry->buyer->email ?? 'N/A'); ?></td>
                                <td><?php echo e($order->quotation->inquiry->itemDescription->name ?? 'N/A'); ?></td>
                                <td><?php echo e(number_format($order->confirmed_quantity)); ?></td>
                                <td>$<?php echo e(number_format($order->confirmed_price, 2)); ?></td>
                                <td><strong>$<?php echo e(number_format($order->total_value, 2)); ?></strong></td>
                                <td>
                                    <?php echo e($order->formatted_delivery_date); ?>

                                    <?php if($order->is_overdue): ?>
                                        <br><small class="text-danger"><i class="fas fa-exclamation-triangle"></i> Overdue</small>
                                    <?php elseif($order->days_until_delivery !== null && $order->days_until_delivery <= 7 && $order->days_until_delivery >= 0): ?>
                                        <br><small class="text-warning"><i class="fas fa-clock"></i> <?php echo e($order->days_until_delivery); ?> days</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($order->status_badge_color); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $order->status))); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.order-confirmations.show', $order)); ?>" 
                                           class="btn btn-info btn-sm" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.order-confirmations.edit', $order)); ?>" 
                                           class="btn btn-warning btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
       <a href="<?php echo e(route('admin.order-confirmations.pdf', $order->id)); ?>" target="_blank" 
   class="btn btn-sm btn-warning">
   Generate PI PDF
</a>
<a href="<?php echo e(route('admin.order-confirmations.sc', $order->id)); ?>" target="_blank" class="btn btn-sm btn-secondary">Generate SC</a>
   <form action="<?php echo e(route('admin.order-confirmations.upload-po', $order->id)); ?>" 
          method="POST" enctype="multipart/form-data" style="display:inline-block;">
        <?php echo csrf_field(); ?>
        <input type="file" name="pi_file" accept="application/pdf" required 
               style="width:180px; margin-bottom:5px;">
        <button type="submit" class="btn btn-sm btn-primary">Upload Buyer PO</button>
    </form>

      <!-- View Buyer PO (if uploaded) -->
    <?php if($order->pi_file): ?>
        <a href="<?php echo e(asset($order->pi_file)); ?>" target="_blank" 
           class="btn btn-sm btn-secondary">View Buyer PO</a>
    <?php endif; ?>


<form action="<?php echo e(route('admin.order-confirmations.update-status', $order->id)); ?>" method="POST" class="d-inline">
    <?php echo csrf_field(); ?>
    <div class="dropdown">
        <button class="btn btn-outline-primary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
            <i class="fas fa-sync-alt me-1"></i> Update Status
        </button>
        <ul class="dropdown-menu">
            <li>
                <button type="submit" name="status" value="pending" class="dropdown-item">Pending</button>
            </li>
            <li>
                <button type="submit" name="status" value="confirmed" class="dropdown-item">Confirmed</button>
            </li>
            <li>
                <button type="submit" name="status" value="in_production" class="dropdown-item">In Production</button>
            </li>
            <li>
                <button type="submit" name="status" value="shipped" class="dropdown-item">Shipped</button>
            </li>
            <li>
                <button type="submit" name="status" value="delivered" class="dropdown-item">Delivered</button>
            </li>
            <li>
                <button type="submit" name="status" value="cancelled" class="dropdown-item">Cancelled</button>
            </li>
        </ul>
    </div>
</form>

                                        <?php if(in_array($order->status, ['pending', 'cancelled'])): ?>
                                            <form action="<?php echo e(route('admin.order-confirmations.destroy', $order)); ?>" 
                                                  method="POST" style="display:inline-block;"
                                                  onsubmit="return confirm('Are you sure you want to delete this order?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">No order confirmations found.</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if($orderConfirmations->hasPages()): ?>
                <div class="d-flex justify-content-center mt-3">
                    <?php echo e($orderConfirmations->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>




<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/order_confirmations/index.blade.php ENDPATH**/ ?>