<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Shipping Label - <?php echo e($order->order_number ?? 'N/A'); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; margin: 0; padding: 10px; }
        .label-container { width: 100mm; height: 150mm; border: 2px solid #000; padding: 5mm; margin: 0 auto; }
        .header { text-align: center; border-bottom: 1px solid #000; padding-bottom: 3mm; margin-bottom: 3mm; }
        .section { margin-bottom: 3mm; }
        .barcode-area { text-align: center; margin: 5mm 0; }
        .barcode { font-family: 'Libre Barcode 128', cursive; font-size: 20px; }
        .warning { background: #ffeb3b; padding: 2mm; text-align: center; font-weight: bold; border: 1px solid #000; }
        .address-box { border: 1px solid #000; padding: 3mm; margin-bottom: 3mm; }
        .handling-info { background: #f8f9fa; padding: 2mm; border: 1px solid #ddd; }
    </style>
</head>
<body>
    <div class="label-container">
        <div class="header">
            <h3 style="margin: 0; font-size: 12px;">SHIPPING LABEL</h3>
            <p style="margin: 2mm 0; font-size: 9px;"><strong>INTERNATIONAL SHIPMENT</strong></p>
        </div>

        <div class="section">
            <div class="address-box">
                <strong>SHIP TO:</strong><br>
                [Consignee Name]<br>
                [Street Address]<br>
                [City, State, ZIP Code]<br>
                [Country]<br>
                Tel: [Phone Number]
            </div>
        </div>

        <div class="section">
            <div class="address-box">
                <strong>FROM:</strong><br>
                [Shipper Name]<br>
                [Shipper Address]<br>
                [Shipper City, Country]<br>
                Tel: [Shipper Phone]
            </div>
        </div>

        <div class="section">
            <table style="width: 100%; border-collapse: collapse; font-size: 9px;">
                <tr>
                    <td><strong>Order No:</strong></td>
                    <td><?php echo e($order->order_number ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td><strong>PO Number:</strong></td>
                    <td><?php echo e($order->customer_po_number ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td><strong>Carton:</strong></td>
                    <td>___ of <?php echo e(ceil($order->confirmed_quantity / 100)); ?></td>
                </tr>
                <tr>
                    <td><strong>Weight:</strong></td>
                    <td>___ kg</td>
                </tr>
                <tr>
                    <td><strong>Date:</strong></td>
                    <td><?php echo e(now()->format('d-M-Y')); ?></td>
                </tr>
            </table>
        </div>

        <div class="barcode-area">
            <div class="barcode">*<?php echo e($order->order_number ?? 'ORDER123'); ?>*</div>
            <div style="font-size: 8px; margin-top: 2mm;"><?php echo e($order->order_number ?? 'ORDER123'); ?></div>
        </div>

        <div class="section">
            <div class="handling-info">
                <strong>HANDLING INSTRUCTIONS:</strong><br>
                ☐ FRAGILE - HANDLE WITH CARE<br>
                ☐ THIS SIDE UP ↑<br>
                ☐ KEEP DRY<br>
                ☐ DO NOT STACK
            </div>
        </div>

        <div class="section">
            <div class="warning">
                ⚠️ INSPECTION REQUIRED<br>
                CHECK CONTENTS UPON RECEIPT
            </div>
        </div>

        <div class="section" style="text-align: center; font-size: 8px;">
            <strong>SHIPPING MARKS:</strong><br>
            ORDER: <?php echo e($order->order_number ?? 'N/A'); ?><br>
            MADE IN: [COUNTRY]<br>
            GROSS WT: ___ kg<br>
            NET WT: ___ kg
        </div>

        <div class="section" style="border-top: 1px solid #000; padding-top: 2mm; text-align: center; font-size: 7px;">
            <strong>CARRIER USE ONLY</strong><br>
            SCAN DATE: ________________<br>
            DRIVER: __________________<br>
            SIGNATURE: ________________
        </div>
    </div>

    <!-- Additional identical labels for multiple copies -->
    <div style="page-break-before: always;"></div>
    
    <div class="label-container">
        <div class="header">
            <h3 style="margin: 0; font-size: 12px;">SHIPPING LABEL</h3>
            <p style="margin: 2mm 0; font-size: 9px;"><strong>INTERNATIONAL SHIPMENT</strong></p>
        </div>

        <div class="section">
            <div class="address-box">
                <strong>SHIP TO:</strong><br>
                [Consignee Name]<br>
                [Street Address]<br>
                [City, State, ZIP Code]<br>
                [Country]<br>
                Tel: [Phone Number]
            </div>
        </div>

        <div class="section">
            <div class="address-box">
                <strong>FROM:</strong><br>
                [Shipper Name]<br>
                [Shipper Address]<br>
                [Shipper City, Country]<br>
                Tel: [Shipper Phone]
            </div>
        </div>

        <div class="section">
            <table style="width: 100%; border-collapse: collapse; font-size: 9px;">
                <tr>
                    <td><strong>Order No:</strong></td>
                    <td><?php echo e($order->order_number ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td><strong>PO Number:</strong></td>
                    <td><?php echo e($order->customer_po_number ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td><strong>Carton:</strong></td>
                    <td>___ of <?php echo e(ceil($order->confirmed_quantity / 100)); ?></td>
                </tr>
                <tr>
                    <td><strong>Weight:</strong></td>
                    <td>___ kg</td>
                </tr>
                <tr>
                    <td><strong>Date:</strong></td>
                    <td><?php echo e(now()->format('d-M-Y')); ?></td>
                </tr>
            </table>
        </div>

        <div class="barcode-area">
            <div class="barcode">*<?php echo e($order->order_number ?? 'ORDER123'); ?>*</div>
            <div style="font-size: 8px; margin-top: 2mm;"><?php echo e($order->order_number ?? 'ORDER123'); ?></div>
        </div>

        <div class="section">
            <div class="handling-info">
                <strong>HANDLING INSTRUCTIONS:</strong><br>
                ☐ FRAGILE - HANDLE WITH CARE<br>
                ☐ THIS SIDE UP ↑<br>
                ☐ KEEP DRY<br>
                ☐ DO NOT STACK
            </div>
        </div>

        <div class="section">
            <div class="warning">
                ⚠️ INSPECTION REQUIRED<br>
                CHECK CONTENTS UPON RECEIPT
            </div>
        </div>

        <div class="section" style="text-align: center; font-size: 8px;">
            <strong>SHIPPING MARKS:</strong><br>
            ORDER: <?php echo e($order->order_number ?? 'N/A'); ?><br>
            MADE IN: [COUNTRY]<br>
            GROSS WT: ___ kg<br>
            NET WT: ___ kg
        </div>

        <div class="section" style="border-top: 1px solid #000; padding-top: 2mm; text-align: center; font-size: 7px;">
            <strong>CARRIER USE ONLY</strong><br>
            SCAN DATE: ________________<br>
            DRIVER: __________________<br>
            SIGNATURE: ________________
        </div>
    </div>
</body>
</html><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/templates/shipping_label.blade.php ENDPATH**/ ?>