<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">Company Details</h2>
        <a href="<?php echo e(route('admin.sellers.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Company
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-dark">
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Company</th>
                        <th scope="col">Telephone</th>
                        <th scope="col">VAT</th>
                        <th scope="col">Image</th>
                        <th scope="col" class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($seller->id); ?></td>
                            <td>
                                <strong><?php echo e($seller->company_name); ?></strong><br>
                                <small class="text-muted"><?php echo e($seller->road); ?> <?php echo e($seller->avenue); ?> <?php echo e($seller->plot); ?></small>
                            </td>
                            <td><?php echo e($seller->telephone ?? '-'); ?></td>
                            <td><?php echo e($seller->vat ?? '-'); ?></td>
                            <td>
                                <?php if($seller->image1): ?>
                                    <img src="<?php echo e(asset($seller->image1)); ?>" alt="Image" class="img-thumbnail" style="width:60px; height:60px; object-fit:cover;">
                                <?php else: ?>
                                    <span class="text-muted">No Image</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('admin.sellers.show', $seller->id)); ?>" class="btn btn-sm btn-info me-1">
                                    <i class="bi bi-eye"></i> View
                                </a>
                                <a href="<?php echo e(route('admin.sellers.edit', $seller->id)); ?>" class="btn btn-sm btn-warning me-1">
                                    <i class="bi bi-pencil-square"></i> Edit
                                </a>
                                <form action="<?php echo e(route('admin.sellers.destroy', $seller->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this seller?');">
                                        <i class="bi bi-trash"></i> Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">No sellers found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/sellers/index.blade.php ENDPATH**/ ?>