<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Shipments'); ?>

    <a href="<?php echo e(route('admin.shipments.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Create Shipment
    </a>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Shipment Entry</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Shipment No</th>
                        <th>Order No</th>
                        <th>Shipment Date</th>
                        <th>Vessel/Flight</th>
                        <th>Port of Loading</th>
                        <th>Status</th>
                        <th>Cartons</th>
                        <th>Quantity</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" class="text-decoration-none">
                                <?php echo e($shipment->shipment_number); ?>

                            </a>
                        </td>
                        <td><?php echo e($shipment->orderConfirmation->order_number); ?></td>
                        <td><?php echo e($shipment->shipment_date->format('M d, Y')); ?></td>
                        <td><?php echo e($shipment->vessel_flight_no ?? 'N/A'); ?></td>
                        <td><?php echo e($shipment->port_of_loading ?? 'N/A'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($shipment->status_badge_color); ?>">
                                <?php echo e(ucfirst($shipment->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($shipment->total_cartons); ?></td>
                        <td><?php echo e(number_format($shipment->total_quantity)); ?></td>
                        <td class="table-actions">
                            <a href="<?php echo e(route('admin.shipments.show', $shipment)); ?>" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.shipments.edit', $shipment)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="<?php echo e(route('admin.shipments.carton-details.index', $shipment)); ?>" class="btn btn-sm btn-success" title="Carton Details">
                                <i class="fas fa-box"></i>
                            </a>
                            <a href="<?php echo e(route('admin.shipments.booking-invoices.index', $shipment)); ?>" class="btn btn-sm btn-primary" title="Booking Invoice">
                                <i class="fas fa-file"></i>
                            </a>
                            <form action="<?php echo e(route('admin.shipments.destroy', $shipment)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            <?php echo e($shipments->links()); ?>

        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/shipment/shipments/index.blade.php ENDPATH**/ ?>