<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .input-group-text {
        border-right: none;
    }
    .form-control {
        border-left: none;
    }
    label{
        font-weight: 700;
    }
</style>

<div class="container mt-5">
    <h2 class="mb-4">Add Buyer</h2>

    <form action="<?php echo e(route('admin.buyers.store')); ?>" method="POST" class="bg-white p-4 shadow rounded">
        <?php echo csrf_field(); ?>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="company_name">Company Name <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-city-alt"></i></span>
                    </div>
                    <input type="text" name="company_name" id="company_name" class="form-control" placeholder="Enter company name" required>
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="contact_person">Contact Person <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-account"></i></span>
                    </div>
                    <input type="text" name="contact_person" id="contact_person" class="form-control" placeholder="Enter contact name" required>
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="email">Email <span class="text-danger">*</span></label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-email"></i></span>
                    </div>
                    <input type="email" name="email" id="email" class="form-control" placeholder="example@domain.com" required>

                </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <small class="text-danger"><i class="zmdi zmdi-alert-circle"></i> <?php echo e($message); ?></small>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group col-md-6">
                <label for="phone">Phone</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-phone"></i></span>
                    </div>
                    <input type="text" name="phone" id="phone" class="form-control" placeholder="Enter phone number">
                </div>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="country">Country</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-globe"></i></span>
                    </div>
                    <input type="text" name="country" id="country" class="form-control" placeholder="Enter country name">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="address">Address</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-pin"></i></span>
                    </div>
                    <textarea name="address" id="address" class="form-control" rows="2" placeholder="Enter full address"></textarea>
                </div>
            </div>
        </div>

                <div class="form-row">
            <div class="form-group col-md-6">
                <label for="country">FAX </label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-globe"></i></span>
                    </div>
                    <input type="text" name="fax" id="country" class="form-control" placeholder="Enter fax number">
                </div>
            </div>

            <div class="form-group col-md-6">
                <label for="address">COMPANY VAT NUMBER</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-white"><i class="zmdi zmdi-pin"></i></span>
                    </div>
                      <input type="text" name="vat" id="country" class="form-control" placeholder="Enter vat number">
                </div>
            </div>
        </div>

         <div class="form-row">
      <div class="form-group col-md-6">
        <label for="bank_id">Select Bank (to attach to buyer)</label>
        <select name="bank_id" id="bank_id" class="form-control">
          <option value="">-- None --</option>
          <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($bank->id); ?>"><?php echo e($bank->bank_name); ?> — <?php echo e($bank->account_no); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    </div>

    <!-- display bank details here -->
    <div id="bank-details" class="bank-details" style="display:none;">
      <h5>Bank details</h5>
      <p><strong>A/C NAME:</strong> <span id="bd-account_name"></span></p>
      <p><strong>A/C NO:</strong> <span id="bd-account_no"></span></p>
      <p><strong>IBAN:</strong> <span id="bd-iban"></span></p>
      <p><strong>SWIFT:</strong> <span id="bd-swift"></span></p>
      <p><strong>Bank Name:</strong> <span id="bd-bank_name"></span></p>
      <p><strong>Bank Address:</strong> <span id="bd-bank_address"></span></p>
      <p><strong>CORRESPONDENT BANK:</strong> <span id="bd-correspondent_bank"></span></p>
      <p><strong>CORRESPONDENT SWIFT:</strong> <span id="bd-correspondent_swift"></span></p>
      <p><strong>CORRESPONDENT A/C NO:</strong> <span id="bd-correspondent_account"></span></p>
    </div>


 <div class="mt-3">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> Save
            </button>
            <a href="<?php echo e(route('admin.buyers.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>

    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const bankSelect = document.getElementById('bank_id');
    const details = document.getElementById('bank-details');

    bankSelect.addEventListener('change', function () {
        const bankId = this.value;
        if (!bankId) {
            details.style.display = 'none';
            return;
        }

        // fetch bank JSON
        fetch("<?php echo e(url('admin/banks')); ?>/" + bankId + "/json", {
            headers: { 'X-Requested-With': 'XMLHttpRequest' }
        }).then(r => r.json()).then(data => {
            document.getElementById('bd-account_name').textContent = data.account_name || '';
            document.getElementById('bd-account_no').textContent = data.account_no || '';
            document.getElementById('bd-iban').textContent = data.iban || '';
            document.getElementById('bd-swift').textContent = data.swift || '';
            document.getElementById('bd-bank_name').textContent = data.bank_name || '';
            document.getElementById('bd-bank_address').textContent = data.bank_address || '';
            document.getElementById('bd-correspondent_bank').textContent = data.correspondent_bank || '';
            document.getElementById('bd-correspondent_swift').textContent = data.correspondent_swift || '';
            document.getElementById('bd-correspondent_account').textContent = data.correspondent_account || '';
            details.style.display = 'block';
        }).catch(err => {
            console.error(err);
            details.style.display = 'none';
        });
    });
});
</script>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/buyers/create.blade.php ENDPATH**/ ?>