<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.document-templates.index')); ?>">Templates</a></li>
                        <li class="breadcrumb-item active">Edit Template</li>
                    </ol>
                </div>
                <h4 class="page-title">Edit Template</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.document-templates.update', $documentTemplate->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Template Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="name" name="name" value="<?php echo e(old('name', $documentTemplate->name)); ?>" 
                                           placeholder="Enter template name" required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">Document Type <span class="text-danger">*</span></label>
                                    <select class="form-select <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="type" name="type" required>
                                        <option value="">Select Document Type</option>
                                        <option value="commercial_invoice" <?php echo e(old('type', $documentTemplate->type) == 'commercial_invoice' ? 'selected' : ''); ?>>Commercial Invoice</option>
                                        <option value="packing_list" <?php echo e(old('type', $documentTemplate->type) == 'packing_list' ? 'selected' : ''); ?>>Packing List</option>
                                        <option value="certificate_origin" <?php echo e(old('type', $documentTemplate->type) == 'certificate_origin' ? 'selected' : ''); ?>>Certificate of Origin</option>
                                        <option value="bill_of_lading" <?php echo e(old('type', $documentTemplate->type) == 'bill_of_lading' ? 'selected' : ''); ?>>Bill of Lading</option>
                                        <option value="inspection_certificate" <?php echo e(old('type', $documentTemplate->type) == 'inspection_certificate' ? 'selected' : ''); ?>>Inspection Certificate</option>
                                        <option value="shipping_label" <?php echo e(old('type', $documentTemplate->type) == 'shipping_label' ? 'selected' : ''); ?>>Shipping Label</option>
                                    </select>
                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="content" class="form-label">Template Content <span class="text-danger">*</span></label>
                                    <textarea class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="content" name="content" rows="15" 
                                              placeholder="Enter HTML template content with variables like {order_number}, {buyer_name}, etc." 
                                              required><?php echo e(old('content', $documentTemplate->content)); ?></textarea>
                                    <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">
                                        Use variables like: <code>{order_number}</code>, <code>{buyer_name}</code>, <code>{order_date}</code>, <code>{total_amount}</code>
                                    </small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="variables" class="form-label">Available Variables (JSON)</label>
                                    <textarea class="form-control <?php $__errorArgs = ['variables'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="variables" name="variables" rows="5"
                                              placeholder='{"order_number": "Order Number", "buyer_name": "Buyer Name" }'><?php echo e(old('variables', $documentTemplate->variables ? json_encode($documentTemplate->variables) : '')); ?></textarea>
                                    <?php $__errorArgs = ['variables'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <small class="form-text text-muted">
                                        Define available variables in JSON format
                                    </small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check form-switch mb-2">
                                        <input type="checkbox" class="form-check-input" 
                                               id="is_active" name="is_active" value="1" 
                                               <?php echo e(old('is_active', $documentTemplate->is_active) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">Active Template</label>
                                    </div>

                                    <div class="form-check form-switch">
                                        <input type="checkbox" class="form-check-input" 
                                               id="is_default" name="is_default" value="1"
                                               <?php echo e(old('is_default', $documentTemplate->is_default) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_default">Set as Default Template</label>
                                    </div>

                                    <div class="mt-3">
                                        <small class="text-muted">
                                            <strong>Note:</strong> Setting as default will remove default status from other templates of the same type.
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="<?php echo e(route('admin.document-templates.index')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Cancel
                                    </a>
                                    <div>
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-save me-1"></i> Update Template
                                        </button>
                                        <button type="button" class="btn btn-danger" 
                                                onclick="confirmDelete(<?php echo e($documentTemplate->id); ?>)">
                                            <i class="fas fa-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                    <form id="delete-form-<?php echo e($documentTemplate->id); ?>" 
                          action="<?php echo e(route('admin.document-templates.destroy', $documentTemplate->id)); ?>" 
                          method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(id) {
    if (confirm('Are you sure you want to delete this template?')) {
        document.getElementById('delete-form-' + id).submit();
    }
}
</script>

<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/document-generator/templates/edit.blade.php ENDPATH**/ ?>