<?php echo $__env->make('admin.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Edit Payment Allocation'); ?>

<?php $__env->startSection('actions'); ?>
    <a href="<?php echo e(route('admin.payment-allocations.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Allocations
    </a>
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Edit Payment Allocation</h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.payment-allocations.update', $paymentAllocation)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Advance Payment</label>
                                <input type="text" class="form-control" value="<?php echo e($paymentAllocation->advancePayment->reference_number); ?> - <?php echo e($paymentAllocation->advancePayment->buyer->company_name); ?>" readonly>
                                <input type="hidden" name="advance_payment_id" value="<?php echo e($paymentAllocation->advance_payment_id); ?>">
                                <small class="form-text text-muted">
                                    Available: $<?php echo e(number_format($paymentAllocation->advancePayment->remaining_amount + $paymentAllocation->amount, 2)); ?>

                                </small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="factory_id" class="form-label">Factory *</label>
                                <select name="factory_id" id="factory_id" class="form-select" required>
                                    <option value="">Select Factory</option>
                                    <?php $__currentLoopData = $factories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($factory->id); ?>" <?php echo e($paymentAllocation->factory_id == $factory->id ? 'selected' : ''); ?>>
                                        <?php echo e($factory->name); ?> - <?php echo e($factory->location); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['factory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($order->id); ?>" <?php echo e($paymentAllocation->order_confirmation_id == $order->id ? 'selected' : ''); ?>>
                                        <?php echo e($order->order_number); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['order_confirmation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Allocation Amount ($) *</label>
                                <input type="number" step="0.01" min="0.01" name="amount" id="amount" 
                                       class="form-control" value="<?php echo e(old('amount', $paymentAllocation->amount)); ?>" required>
                                <small class="form-text text-muted">
                                    Current: $<?php echo e(number_format($paymentAllocation->amount, 2)); ?> | 
                                    Available: $<?php echo e(number_format($paymentAllocation->advancePayment->remaining_amount + $paymentAllocation->amount, 2)); ?>

                                </small>
                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="allocation_date" class="form-label">Allocation Date *</label>
                                <input type="date" name="allocation_date" id="allocation_date" 
                                       class="form-control" value="<?php echo e(old('allocation_date', $paymentAllocation->allocation_date->format('Y-m-d'))); ?>" required>
                                <?php $__errorArgs = ['allocation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="purpose" class="form-label">Purpose *</label>
                        <textarea name="purpose" id="purpose" class="form-control" rows="3" required><?php echo e(old('purpose', $paymentAllocation->purpose)); ?></textarea>
                        <?php $__errorArgs = ['purpose'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="2"><?php echo e(old('remarks', $paymentAllocation->remarks)); ?></textarea>
                        <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?php echo e(route('admin.payment-allocations.index')); ?>" class="btn btn-secondary me-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Update Allocation</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Allocation Info</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Reference:</strong><br>
                    <?php echo e($paymentAllocation->reference_number); ?>

                </div>
                <div class="mb-3">
                    <strong>Created By:</strong><br>
                    <?php echo e($paymentAllocation->creator->name); ?><br>
                    <small class="text-muted"><?php echo e($paymentAllocation->created_at->format('M d, Y H:i')); ?></small>
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong><br>
                    <small class="text-muted"><?php echo e($paymentAllocation->updated_at->format('M d, Y H:i')); ?></small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Advance Payment Status</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>Original Amount:</strong><br>
                    $<?php echo e(number_format($paymentAllocation->advancePayment->amount, 2)); ?>

                </div>
                <div class="mb-2">
                    <strong>Allocated:</strong><br>
                    $<?php echo e(number_format($paymentAllocation->advancePayment->allocated_amount, 2)); ?>

                </div>
                <div class="mb-2">
                    <strong>Remaining:</strong><br>
                    $<?php echo e(number_format($paymentAllocation->advancePayment->remaining_amount, 2)); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH E:\xampp2\htdocs\texsia\resources\views/admin/payment/allocations/edit.blade.php ENDPATH**/ ?>