 @include('header')
 <style>
  .post-thumb {
    height: 200px;
    object-fit: cover;
    width: 100%;
  }
  .badge{
    background: var(--brand-color)!important;  

  }
  .card{
    background: var(--boxColor);;
  }
  .overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.7); /* black overlay with 70% opacity */
  transition: all 0.3s ease-in-out;
}
 
</style>
  <section class="breadcrumbs py-4 " data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <ol>
        <li><a href="{{ url('/') }}">Home</a></li>
        <li>tags</li>
      </ol>
      <h2 class="title">Posts tagged with "{{ $tag }}"</h2>
   
    </div>
  </section><!-- End Breadcrumbs -->

  
<div class="container my-4 mb-5">
  <h2 class="mb-4">Posts tagged with: <span style="color: var(--brand-color);">{{ $tag }}</span></h2>

  @if($posts->count())
    @foreach($posts as $post)
      <div class="card mb-4  border-0">
        <div class="row g-0">
          <div class="col-md-4  position-relative overflow-hidden">
            <img src="{{ asset('blogs/' . $post->image) }}" class="img-fluid rounded-start post-thumb" alt="{{ $post->title }}">
              <div class="overlay"></div>

              <span class="badge category-badge position-absolute top-0 start-0 m-2" style="border-radius: 1px!important;">
    {{ $post->category->name }}
  </span>
          </div>
          <div class="col-md-8">
            <div class="card-body">
         
                <a href="{{ route('details', $post->slug) }}" class="text-decoration-none ">
                     <h4 class="title-2" >  {{ $post->title }}   </h4>
                </a>
           
              <p class="card-text ">{{ $post->short_description }}</p>

              <div class="d-flex flex-wrap align-items-center mt-5">
                <small class="text-secondary me-3">
                  <i class="bi bi-calendar-event"></i> {{ $post->created_at->format('M d, Y') }}
                </small>

                <div class="tags">
                  @foreach(explode(',', $post->tags) as $tagItem)
                    <a href="{{ route('posts', trim($tagItem)) }}" class="badge bg-primary text-white me-1 mb-1">
                      {{ trim($tagItem) }}
                    </a>
                  @endforeach
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    @endforeach
  @else
    <h6 >No posts found for this tag.</h6>
  @endif
</div>


   @include('footer')
