<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <meta name="description" content="Zinaxi is a leading software company providing Web Development, Mobile App Development, AI Solutions, Graphic Design, and Digital Marketing services. Grow your business with our expert solutions.">
  <meta name="keywords" content="web development, mobile app development, AI development, software company, graphic design, digital marketing, Zinaxi">
  <meta name="author" content="Zinaxi">
  <meta name="robots" content="index, follow">

  <!-- Open Graph / Facebook -->
  <meta property="og:title" content="Zinaxi - Web, AI, Mobile App & Digital Marketing Experts">
  <meta property="og:description" content="Zinaxi provides expert web development, AI solutions, mobile apps, graphic design, and digital marketing services to boost your business.">
  <meta property="og:image" content="{{ asset('images/logo/ZinaxiT.PNG') }}">
  <meta property="og:url" content="https://www.yourwebsite.com">
  <meta property="og:type" content="website">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Zinaxi - Web Development, AI, Mobile Apps & Digital Marketing">
  <meta name="twitter:description" content="Leading software company specializing in Web, AI, Mobile Apps, and Digital Marketing. Get expert solutions from Zinaxi.">
  <meta name="twitter:image" content="{{ asset('images/logo/ZinaxiT.PNG') }}">

  <!-- Favicons -->
  <link rel="icon" href="{{ asset('images/favicon.ico') }}">
  <link rel="icon" type="image/png" href="{{ asset('images/favicon.ico') }}">
  <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('images/favicon.ico') }}">
  <link rel="icon" type="image/png" sizes="192x192" href="{{ asset('images/favicon.ico') }}">

  <!-- JSON-LD Structured Data for SEO -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Zinaxi",
  "url": "https://www.yourlivedomain.com",
  "logo": "https://www.yourlivedomain.com/images/logo/ZinaxiT.PNG",
  "contactPoint": [
    {
      "@type": "ContactPoint",
      "telephone": "+923059741380",
      "contactType": "customer support",
      "email": "info@zinaxi.com",
      "areaServed": "Global"
    }
  ],
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "123 Business Street",
    "addressLocality": "Lahore",
    "addressRegion": "Punjab",
    "postalCode": "54000",
    "addressCountry": "Pakistan"
  },
  "openingHours": [
    "Mo-Fr 09:00-18:00",
    "Sa 10:00-14:00"
  ],
  "sameAs": [
    "https://www.facebook.com/zinaxi",
    "https://www.twitter.com/zinaxi",
    "https://www.linkedin.com/company/zinaxi"
  ]
}
</script>


  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="{{ URL::asset('css/bootstrap.min.css') }}">

  <!-- AOS CSS -->
  <link rel="stylesheet" href="{{ URL::asset('css/aos.css') }}">

  <!-- Fancybox CSS -->
  <link rel="stylesheet" href="{{ URL::asset('css/jquery.fancybox.min.css') }}">

  <!-- Owl Carousel CSS -->
  <link rel="stylesheet" href="{{ URL::asset('css/owl.carousel.min.css') }}">
  <link rel="stylesheet" href="{{ URL::asset('css/owl.theme.default.min.css') }}">

  <!-- Toastr Notifications CSS -->
  <link rel="stylesheet" href="{{ URL::asset('cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css') }}">

  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="{{ URL::asset('cdn.jsdelivr.net/npm/bootstrap-icons%401.11.3/font/bootstrap-icons.min.css') }}">

  <!-- Google Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,100..900;1,100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Main CSS File -->
  <link rel="stylesheet" href="{{ URL::asset('css/style.css') }}">

  <title>Zinaxi - IT Solutions & Business Services | Web, AI & Mobile Apps</title>

  <style>
    @media only screen and (max-width: 500px) {
      .navbar .logo {
        width: 7rem;
      }
    }
    body{  font-family: Jost,sans-serif!important
}
.dark-mode #hero {
    background-image: none !important;
    background-color: #121212; /* Optional: Add a dark background color */

}
#hero {
    background-image: url('images/logo/bg.png');
    position: relative;
z-index: 2;
  
}
@keyframes slideLeftRight {
    0% {
        transform: translateX(0);
    }
    50% {
        transform: translateX(10px);
    }
    100% {
        transform: translateX(0);
    }
}

.animated-icon {
    display: inline-block; /* Ensures animation works */
    animation: slideLeftRight 2s infinite ease-in-out;
}

#whatsapp .wtsapp:focus {    border: none;    outline: none;}

#whatsapp .wtsapp {    position: fixed;    transition: all .5s ease;    background: #25d366;    display: block;    text-align: center;    box-shadow: 0 0 20px rgba(0,0,0,0.15);    /* margin: 0; */    border-radius: 50px;    border-right: none;    color: #fff;    font-weight: 700;    font-size: 18px;    bottom: 30px; right: 20px;      border: 0;    z-index: 99;    width: 50px;    height: 50px;    line-height: 48px;}

#whatsapp .wtsapp:before {    content: "";    position: absolute;    z-index: -1;    left: 50%;    top: 50%;    transform: translateX(-50%) translateY(-50%);    display: block;    width: 60px;    height: 60px;    background: #25d366;    border-radius: 50%;    -webkit-animation: pulse-border 1500ms ease-out infinite;    animation: pulse-border 1500ms ease-out infinite;}

@keyframes pulse-border {

0% {transform: translateX(-50%) translateY(-50%) translateZ(0) scale(1); opacity: 1;}

100% {transform: translateX(-50%) translateY(-50%) translateZ(0) scale(1.5); opacity: 0;}

}
  </style>

</head>


<body class="home-1 ">

  <!-- start preLoader -->
<!--   <div id="preloader">
    <svg id="mainSVG" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 800 600">
      <defs>
        <radialGradient id="mainGrad" cx="400" cy="300" fx="400" fy="300" r="100" gradientUnits="userSpaceOnUse">
          <stop offset=".68" stop-color="#21df51" />
          <stop offset=".72" stop-color="#3add63" />
          <stop offset=".77" stop-color="#4fdd73" />
          <stop offset=".82" stop-color="#66db83" />
          <stop offset=".88" stop-color="#7cd893" />
          <stop offset=".93" stop-color="#95d8a6" />
          <stop offset=".99" stop-color="#bde6c7" />
          <stop offset="1" stop-color="#e3f1e7" />
        </radialGradient>
      </defs>
      <circle id="fillDot" cx="400" cy="300" fill="#21df51" r="100" />
      <circle id="gradDot" cx="400" cy="300" fill="url(#mainGrad)" r="100" />
    </svg>
  </div> -->
  <!-- end preLoader -->

  <!-- start scroll to top button -->
<!--   <div id="progress">
    <span id="progress-value"><i class="bi bi-arrow-up-short"></i></span>
  </div> -->
  <!-- end scroll to top button -->


  <!-- ======= start Header ======= -->
  <header class="header ">
    <nav class="navbar navbar-expand-lg navbar-light  fixed-top">
      <div class="container">
        <a class="navbar-brand " href="{{ url('/') }}">   <img src="{{ asset('images/logo/ZinaxiT.PNG') }}" id="logo" 
     data-dark-logo="{{ asset('images/logo/tooglelogo.PNG') }}" 
     data-light-logo="{{ asset('images/logo/ZinaxiT.PNG') }}" class="logo" alt="Logo"></a>
     

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
          aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
          <i class="bi bi-list" id="menu"></i>
        </button>
        <div class="collapse navbar-collapse justify-content-between" id="navbarNav">
          <ul class="navbar-nav ms-auto" id="navbar">
            <li class="nav-item ">
              <a class="nav-link " href="{{ url('/') }}" >
                Home
              </a>
            <!--   <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                <li><a class="dropdown-item py-2" href="index.html">Home</a></li>
                <li><a class="dropdown-item py-2" href="index-2.html">Home 2</a></li>
                <li><a class="dropdown-item py-2" href="index-3.html">Home 3</a></li>
                <li><a class="dropdown-item py-2" href="index-rtl.html">Home RTL</a></li>
              </ul> -->
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{route('about')}}">About</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{route('service')}}">Services</a>
            </li>
         <!--    <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown1" role="button" data-bs-toggle="dropdown"
                aria-expanded="false">
                pages
              </a>
              <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                <li><a class="dropdown-item py-2" href="404.html">404 page</a></li>
                <li><a class="dropdown-item py-2" href="blog.html">blog</a></li>
                <li><a class="dropdown-item py-2" href="blog-single.html">single blog page</a></li>
                <li><a class="dropdown-item py-2" href="about.html">about</a></li>
                <li><a class="dropdown-item py-2" href="services.html">services</a></li>
                <li><a class="dropdown-item py-2" href="service-single.html">service single</a></li>
                <li><a class="dropdown-item py-2" href="portfolio.html">portfolio</a></li>
                <li><a class="dropdown-item py-2" href="portfolio-single.html">portfolio single</a></li>
                <li><a class="dropdown-item py-2" href="privacy-policy.html">privacy policy</a></li>
                <li><a class="dropdown-item py-2" href="terms-of-use.html">terms of use</a></li>
                <li><a class="dropdown-item py-2" href="contact.html">contact</a></li>
                <li><a class="dropdown-item py-2" href="login.html">login page</a></li>
                <li><a class="dropdown-item py-2" href="register.html">register</a></li>
              </ul>
            </li> -->
            <li class="nav-item">
              <a class="nav-link" href="{{ route('portfolio') }}">portfolio</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('blog') }}">Blog</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="{{ route('contact') }}">contact us</a>
            </li>
          </ul>
          <div class="d-flex ms-auto">
            <a class="btn" href="contact.html">join now</a>
            <button id="mode-toggle" class="btn-light-mode switch-button"><i id="mode-icon"
                class="bi bi-moon-fill"></i></button>
          </div>
        </div>
      </div>
    </nav>
  </header>
  <!-- ======= end Header ======= -->

                    <div id="whatsapp"><a href="https://wa.me/923137049773" target="_blank" class="wtsapp" > <i style="font-size: 30px;" class="bi bi-whatsapp" ></i></a></div>
