@include('admin.header')

<div class="container py-4">
    <h4 class="mb-3">View Term Details</h4>

    <div class="card shadow-sm p-4">
        <h5>{{ $term->title }}</h5>
        <p><strong>Input Type:</strong> {{ ucfirst($term->input_type) }}</p>
        <p><strong>Visible:</strong> {{ $term->visible ? 'Yes' : 'No' }}</p>
        <p><strong>Sort Order:</strong> {{ $term->sort_order }}</p>
        <p><strong>Created By:</strong> {{ $term->created_by ?? 'N/A' }}</p>
        <hr>
        <p><strong>Content:</strong></p>
        <div class="border rounded p-3 bg-light">
            {!! nl2br(e($term->content)) !!}
        </div>
    </div>

    <div class="mt-4">
        <a href="{{ route('admin.terms.index') }}" class="btn btn-secondary">Back</a>
        <a href="{{ route('admin.terms.edit', $term->id) }}" class="btn btn-warning text-white">Edit</a>
    </div>
</div>
@include('admin.footer')
