@include('admin.header')

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">General Terms & Conditions</h4>
        <a href="{{ route('admin.terms.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add New Term
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Input Type</th>
                        <th>Visible</th>
                        <th>Sort</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($terms as $term)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $term->title }}</td>
                            <td>{{ ucfirst($term->input_type) }}</td>
                            <td>
                                @if($term->visible)
                                    <span class="badge bg-success">Yes</span>
                                @else
                                    <span class="badge bg-secondary">No</span>
                                @endif
                            </td>
                            <td>{{ $term->sort_order }}</td>
                            <td>
                                <a href="{{ route('admin.terms.show', $term->id) }}" class="btn btn-sm btn-info text-white">View</a>
                                <a href="{{ route('admin.terms.edit', $term->id) }}" class="btn btn-sm btn-warning text-white">Edit</a>
                                <form action="{{ route('admin.terms.destroy', $term->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this term?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="7" class="text-center text-muted">No terms added yet.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@include('admin.footer')

