@include('admin.header')

@section('title', 'Shipment Details')

    <a href="{{ route('admin.shipments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Shipments
    </a>
    <a href="{{ route('admin.shipments.edit', $shipment) }}" class="btn btn-warning">
        <i class="fas fa-edit me-1"></i> Edit
    </a>
    <a href="{{ route('admin.shipments.carton-details.create', $shipment) }}" class="btn btn-success">
        <i class="fas fa-box me-1"></i> Add Carton
    </a>
    <a href="{{ route('admin.shipments.booking-invoices.create', $shipment) }}" class="btn btn-primary">
        <i class="fas fa-file-invoice me-1"></i> Booking Invoice
    </a>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Shipment Details</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Shipment Number</th>
                                <td>{{ $shipment->shipment_number }}</td>
                            </tr>
                            <tr>
                                <th>Order Confirmation</th>
                                <td>{{ $shipment->orderConfirmation->order_number }}</td>
                            </tr>
                            <tr>
                                <th>Shipment Date</th>
                                <td>{{ $shipment->shipment_date->format('M d, Y') }}</td>
                            </tr>
                            <tr>
                                <th>Vessel/Flight No</th>
                                <td>{{ $shipment->vessel_flight_no ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Bill of Lading</th>
                                <td>{{ $shipment->bill_of_lading ?? 'N/A' }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-bordered">
                            <tr>
                                <th width="40%">Port of Loading</th>
                                <td>{{ $shipment->port_of_loading ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Port of Discharge</th>
                                <td>{{ $shipment->port_of_discharge ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>ETD</th>
                                <td>{{ $shipment->etd ? $shipment->etd->format('M d, Y') : 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>ETA</th>
                                <td>{{ $shipment->eta ? $shipment->eta->format('M d, Y') : 'N/A' }}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span class="badge bg-{{ $shipment->status_badge_color }}">
                                        {{ ucfirst($shipment->status) }}
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                @if($shipment->remarks)
                <div class="row">
                    <div class="col-12">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Remarks</label>
                            <div class="border p-3 bg-light rounded">
                                {{ $shipment->remarks }}
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Carton Details Section -->
        <div class="card mt-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Carton Details</h5>
                <a href="{{ route('admin.shipments.carton-details.create', $shipment) }}" class="btn btn-sm btn-success">
                    <i class="fas fa-plus me-1"></i> Add Carton
                </a>
            </div>
            <div class="card-body">
                @if($shipment->cartonDetails->count() > 0)
                <div class="table-responsive">
                    <table class="table table-sm table-hover">
                        <thead>
                            <tr>
                                <th>Carton No</th>
                                <th>Quantity</th>
                                <th>Gross Weight</th>
                                <th>Net Weight</th>
                                <th>Volume</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($shipment->cartonDetails as $carton)
                            <tr>
                                <td>{{ $carton->carton_number }}</td>
                                <td>{{ number_format($carton->quantity) }}</td>
                                <td>{{ $carton->gross_weight ? number_format($carton->gross_weight, 2) . ' kg' : 'N/A' }}</td>
                                <td>{{ $carton->net_weight ? number_format($carton->net_weight, 2) . ' kg' : 'N/A' }}</td>
                                <td>{{ $carton->volume ? number_format($carton->volume, 3) . ' m³' : 'N/A' }}</td>
                                <td>{{ Str::limit($carton->description, 30) }}</td>
                                <td>
                                    <a href="{{ route('admin.shipments.carton-details.edit', [$shipment, $carton]) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.shipments.carton-details.destroy', [$shipment, $carton]) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="table-dark">
                                <th>Total</th>
                                <th>{{ number_format($shipment->total_quantity) }}</th>
                                <th>{{ number_format($shipment->total_weight, 2) }} kg</th>
                                <th colspan="4"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                @else
                <div class="text-center text-muted py-4">
                    <i class="fas fa-box fa-3x mb-3"></i>
                    <p>No carton details added yet.</p>
                    <a href="{{ route('admin.shipments.carton-details.create', $shipment) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Add First Carton
                    </a>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Order Information</h6>
            </div>
            <div class="card-body">
                <h6>{{ $shipment->orderConfirmation->order_number }}</h6>
                <ul class="list-unstyled">
                    <li><strong>Quantity:</strong> {{ number_format($shipment->orderConfirmation->confirmed_quantity) }}</li>
                    <li><strong>Price:</strong>${{ number_format($shipment->orderConfirmation->confirmed_price, 2) }}</li>
                    <li><strong>Delivery:</strong> {{ $shipment->orderConfirmation->formatted_delivery_date }}</li>
                    <li><strong>Status:</strong> 
                        <span class="badge bg-{{ $shipment->orderConfirmation->status_badge_color }}">
                            {{ ucfirst($shipment->orderConfirmation->status) }}
                        </span>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Quick Actions</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.shipments.carton-details.create', $shipment) }}" class="btn btn-outline-success">
                        <i class="fas fa-box me-1"></i> Add Carton Details
                    </a>
                    <a href="{{ route('admin.shipments.booking-invoices.create', $shipment) }}" class="btn btn-outline-primary">
                        <i class="fas fa-file-invoice me-1"></i> Create Booking Invoice
                    </a>
                    <a href="{{ route('admin.shipments.final-shipments.create', $shipment) }}" class="btn btn-outline-info">
                        <i class="fas fa-ship me-1"></i> Final Shipment Update
                    </a>
                </div>
            </div>
        </div>

        <!-- Summary -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">Shipment Summary</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>Total Cartons:</strong>
                    <span class="float-end">{{ $shipment->total_cartons }}</span>
                </div>
                <div class="mb-2">
                    <strong>Total Quantity:</strong>
                    <span class="float-end">{{ number_format($shipment->total_quantity) }}</span>
                </div>
                <div class="mb-2">
                    <strong>Total Weight:</strong>
                    <span class="float-end">{{ number_format($shipment->total_weight, 2) }} kg</span>
                </div>
                <div class="mb-2">
                    <strong>Created By:</strong>
                    <span class="float-end">{{ $shipment->creator->name }}</span>
                </div>
                <div class="mb-2">
                    <strong>Created At:</strong>
                    <span class="float-end">{{ $shipment->created_at->format('M d, Y H:i') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
