@include('admin.header')

@section('title', 'Shipments')

    <a href="{{ route('admin.shipments.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i> Create Shipment
    </a>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Shipment Entry</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Shipment No</th>
                        <th>Order No</th>
                        <th>Shipment Date</th>
                        <th>Vessel/Flight</th>
                        <th>Port of Loading</th>
                        <th>Status</th>
                        <th>Cartons</th>
                        <th>Quantity</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($shipments as $shipment)
                    <tr>
                        <td>
                            <a href="{{ route('admin.shipments.show', $shipment) }}" class="text-decoration-none">
                                {{ $shipment->shipment_number }}
                            </a>
                        </td>
                        <td>{{ $shipment->orderConfirmation->order_number }}</td>
                        <td>{{ $shipment->shipment_date->format('M d, Y') }}</td>
                        <td>{{ $shipment->vessel_flight_no ?? 'N/A' }}</td>
                        <td>{{ $shipment->port_of_loading ?? 'N/A' }}</td>
                        <td>
                            <span class="badge bg-{{ $shipment->status_badge_color }}">
                                {{ ucfirst($shipment->status) }}
                            </span>
                        </td>
                        <td>{{ $shipment->total_cartons }}</td>
                        <td>{{ number_format($shipment->total_quantity) }}</td>
                        <td class="table-actions">
                            <a href="{{ route('admin.shipments.show', $shipment) }}" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.shipments.edit', $shipment) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="{{ route('admin.shipments.carton-details.index', $shipment) }}" class="btn btn-sm btn-success" title="Carton Details">
                                <i class="fas fa-box"></i>
                            </a>
                            <a href="{{ route('admin.shipments.booking-invoices.index', $shipment) }}" class="btn btn-sm btn-primary" title="Booking Invoice">
                                <i class="fas fa-file"></i>
                            </a>
                            <form action="{{ route('admin.shipments.destroy', $shipment) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $shipments->links() }}
        </div>
    </div>
</div>
@include('admin.footer')
