@include('admin.header')
       <style>
        .table-actions { white-space: nowrap; }
        .status-badge { font-size: 0.7em; }
    </style>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4>Edit Shipment</h4>
                    <a href="{{ route('admin.shipments.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Shipments
                    </a>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Edit Shipment Details</h5>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.shipments.update', $shipment) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                                    <option value="">Select Order</option>
                                                    @foreach($orders as $order)
                                                    <option value="{{ $order->id }}" {{ $shipment->order_confirmation_id == $order->id ? 'selected' : '' }}>
                                                        {{ $order->order_number }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="shipment_date" class="form-label">Shipment Date *</label>
                                                <input type="date" name="shipment_date" id="shipment_date" 
                                                       class="form-control" value="{{ old('shipment_date', $shipment->shipment_date->format('Y-m-d')) }}" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="vessel_flight_no" class="form-label">Vessel/Flight No</label>
                                                <input type="text" name="vessel_flight_no" id="vessel_flight_no" 
                                                       class="form-control" value="{{ old('vessel_flight_no', $shipment->vessel_flight_no) }}">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="bill_of_lading" class="form-label">Bill of Lading</label>
                                                <input type="text" name="bill_of_lading" id="bill_of_lading" 
                                                       class="form-control" value="{{ old('bill_of_lading', $shipment->bill_of_lading) }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="port_of_loading" class="form-label">Port of Loading</label>
                                                <input type="text" name="port_of_loading" id="port_of_loading" 
                                                       class="form-control" value="{{ old('port_of_loading', $shipment->port_of_loading) }}">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="port_of_discharge" class="form-label">Port of Discharge</label>
                                                <input type="text" name="port_of_discharge" id="port_of_discharge" 
                                                       class="form-control" value="{{ old('port_of_discharge', $shipment->port_of_discharge) }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="etd" class="form-label">ETD</label>
                                                <input type="date" name="etd" id="etd" 
                                                       class="form-control" value="{{ old('etd', $shipment->etd ? $shipment->etd->format('Y-m-d') : '') }}">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="eta" class="form-label">ETA</label>
                                                <input type="date" name="eta" id="eta" 
                                                       class="form-control" value="{{ old('eta', $shipment->eta ? $shipment->eta->format('Y-m-d') : '') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label for="status" class="form-label">Status *</label>
                                                <select name="status" id="status" class="form-select" required>
                                                    <option value="draft" {{ $shipment->status == 'draft' ? 'selected' : '' }}>Draft</option>
                                                    <option value="booked" {{ $shipment->status == 'booked' ? 'selected' : '' }}>Booked</option>
                                                    <option value="in_transit" {{ $shipment->status == 'in_transit' ? 'selected' : '' }}>In Transit</option>
                                                    <option value="delivered" {{ $shipment->status == 'delivered' ? 'selected' : '' }}>Delivered</option>
                                                    <option value="cancelled" {{ $shipment->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="remarks" class="form-label">Remarks</label>
                                        <textarea name="remarks" id="remarks" class="form-control" rows="3">{{ old('remarks', $shipment->remarks) }}</textarea>
                                    </div>

                                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                        <a href="{{ route('admin.shipments.index') }}" class="btn btn-secondary me-2">Cancel</a>
                                        <button type="submit" class="btn btn-primary">Update Shipment</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="card-title mb-0">Shipment Info</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong>Shipment Number:</strong><br>
                                    {{ $shipment->shipment_number }}
                                </div>
                                <div class="mb-3">
                                    <strong>Total Cartons:</strong><br>
                                    {{ $shipment->total_cartons }}
                                </div>
                                <div class="mb-3">
                                    <strong>Total Quantity:</strong><br>
                                    {{ number_format($shipment->total_quantity) }}
                                </div>
                                <div class="mb-3">
                                    <strong>Created By:</strong><br>
                                    {{ $shipment->creator->name }}<br>
                                    <small class="text-muted">{{ $shipment->created_at->format('M d, Y H:i') }}</small>
                                </div>
                                <div class="mb-3">
                                    <strong>Last Updated:</strong><br>
                                    <small class="text-muted">{{ $shipment->updated_at->format('M d, Y H:i') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('admin.footer')
   