@include('admin.header')

@section('title', 'Create Shipment')

    <a href="{{ route('admin.shipments.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-1"></i> Back to Shipments
    </a>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Create New Shipment</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.shipments.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="order_confirmation_id" class="form-label">Order Confirmation *</label>
                                <select name="order_confirmation_id" id="order_confirmation_id" class="form-select" required>
                                    <option value="">Select Order</option>
                                    @foreach($orders as $order)
                                    <option value="{{ $order->id }}" {{ old('order_confirmation_id') == $order->id ? 'selected' : '' }}>
                                        {{ $order->order_number }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('order_confirmation_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="shipment_date" class="form-label">Shipment Date *</label>
                                <input type="date" name="shipment_date" id="shipment_date" 
                                       class="form-control" value="{{ old('shipment_date', date('Y-m-d')) }}" required>
                                @error('shipment_date')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="vessel_flight_no" class="form-label">Vessel/Flight No</label>
                                <input type="text" name="vessel_flight_no" id="vessel_flight_no" 
                                       class="form-control" value="{{ old('vessel_flight_no') }}" 
                                       placeholder="e.g., MAERSK HONG KONG">
                                @error('vessel_flight_no')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="bill_of_lading" class="form-label">Bill of Lading</label>
                                <input type="text" name="bill_of_lading" id="bill_of_lading" 
                                       class="form-control" value="{{ old('bill_of_lading') }}" 
                                       placeholder="Bill of lading number">
                                @error('bill_of_lading')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="port_of_loading" class="form-label">Port of Loading</label>
                                <input type="text" name="port_of_loading" id="port_of_loading" 
                                       class="form-control" value="{{ old('port_of_loading') }}" 
                                       placeholder="e.g., Karachi Port">
                                @error('port_of_loading')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="port_of_discharge" class="form-label">Port of Discharge</label>
                                <input type="text" name="port_of_discharge" id="port_of_discharge" 
                                       class="form-control" value="{{ old('port_of_discharge') }}" 
                                       placeholder="e.g., Dubai Port">
                                @error('port_of_discharge')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="etd" class="form-label">ETD (Estimated Time of Departure)</label>
                                <input type="date" name="etd" id="etd" 
                                       class="form-control" value="{{ old('etd') }}">
                                @error('etd')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="eta" class="form-label">ETA (Estimated Time of Arrival)</label>
                                <input type="date" name="eta" id="eta" 
                                       class="form-control" value="{{ old('eta') }}">
                                @error('eta')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="remarks" class="form-label">Remarks</label>
                        <textarea name="remarks" id="remarks" class="form-control" rows="3" 
                                  placeholder="Any additional remarks...">{{ old('remarks') }}</textarea>
                        @error('remarks')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary">Reset</button>
                        <button type="submit" class="btn btn-primary">Create Shipment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">Shipment Guidelines</h6>
            </div>
            <div class="card-body">
                <ul class="list-unstyled">
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Select the correct order confirmation</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Provide accurate shipment dates</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Include vessel/flight details if available</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Specify ports for loading and discharge</li>
                    <li class="mb-2"><i class="fas fa-info-circle text-primary me-2"></i>Shipment will be created as draft initially</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@include('admin.footer')
