@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Final Shipment Details</h4>
                <div>
                    <a href="{{ route('admin.shipments.final-shipments.index', $shipment) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Updates
                    </a>
                    <a href="{{ route('admin.shipments.final-shipments.edit', [$shipment, $finalShipment]) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-1"></i> Edit
                    </a>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Final Shipment Update Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Shipment</th>
                                            <td>{{ $shipment->shipment_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Order Confirmation</th>
                                            <td>{{ $shipment->orderConfirmation->order_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>Original Quantity</th>
                                            <td>{{ number_format($finalShipment->original_quantity) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Adjusted Quantity</th>
                                            <td class="{{ $finalShipment->adjusted_quantity >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ $finalShipment->adjusted_quantity >= 0 ? '+' : '' }}{{ number_format($finalShipment->adjusted_quantity) }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="40%">Final Quantity</th>
                                            <td class="fw-bold text-primary">{{ number_format($finalShipment->final_quantity) }}</td>
                                        </tr>
                                        <tr>
                                            <th>Final Shipment Date</th>
                                            <td>{{ $finalShipment->final_shipment_date->format('M d, Y') }}</td>
                                        </tr>
                                        <tr>
                                            <th>Adjustment Type</th>
                                            <td>
                                                <span class="badge bg-{{ $finalShipment->adjustment_type == 'positive' ? 'success' : 'danger' }}">
                                                    {{ $finalShipment->adjustment_type == 'positive' ? 'Increase' : 'Decrease' }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td>
                                                <span class="badge bg-{{ $finalShipment->status_badge_color }}">
                                                    {{ ucfirst($finalShipment->status) }}
                                                </span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Adjustment Reason</label>
                                        <div class="border p-3 bg-light rounded">
                                            {{ $finalShipment->adjustment_reason }}
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if($finalShipment->inspection_remarks)
                            <div class="row">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label fw-bold">Inspection Remarks</label>
                                        <div class="border p-3 bg-light rounded">
                                            {{ $finalShipment->inspection_remarks }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Shipment Information</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Vessel/Flight:</strong><br>
                                {{ $shipment->vessel_flight_no ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>Port of Loading:</strong><br>
                                {{ $shipment->port_of_loading ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>Port of Discharge:</strong><br>
                                {{ $shipment->port_of_discharge ?? 'N/A' }}
                            </div>
                            <div class="mb-3">
                                <strong>Shipment Status:</strong><br>
                                <span class="badge bg-{{ $shipment->status_badge_color }}">
                                    {{ ucfirst($shipment->status) }}
                                </span>
                            </div>
                            <div class="mb-3">
                                <a href="{{ route('admin.shipments.final-shipments.export-packing-list', [$shipment, $finalShipment]) }}" 
   class="btn btn-sm btn-success" target="_blank">
    <i class="fas fa-file-pdf"></i> Packing List
</a>
<a href="{{ route('admin.shipments.final-shipments.export-final-invoice', [$shipment, $finalShipment]) }}" 
   class="btn btn-sm btn-primary" target="_blank">
    <i class="fas fa-file-pdf"></i> Final Invoice
</a>
                            </div>
                        </div>
                    </div>

                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Update Info</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <strong>Created By:</strong><br>
                                {{ $finalShipment->creator->name }}
                            </div>
                            <div class="mb-3">
                                <strong>Created At:</strong><br>
                                {{ $finalShipment->created_at->format('M d, Y H:i') }}
                            </div>
                            <div class="mb-3">
                                <strong>Last Updated:</strong><br>
                                {{ $finalShipment->updated_at->format('M d, Y H:i') }}
                            </div>
                        </div>
                    </div>

                    <!-- Document Links -->
                    @if($finalShipment->final_invoice_path || $finalShipment->final_packing_list_path)
                    <div class="card mt-3">
                        <div class="card-header">
                            <h6 class="card-title mb-0">Documents</h6>
                        </div>
                        <div class="card-body">
                            @if($finalShipment->final_invoice_path)
                            <div class="mb-2">
                                <a href="{{ asset('storage/' . $finalShipment->final_invoice_path) }}" class="btn btn-sm btn-outline-primary w-100" target="_blank">
                                    <i class="fas fa-file-invoice me-1"></i> Final Invoice
                                </a>
                            </div>
                            @endif
                            @if($finalShipment->final_packing_list_path)
                            <div class="mb-2">
                                <a href="{{ asset('storage/' . $finalShipment->final_packing_list_path) }}" class="btn btn-sm btn-outline-success w-100" target="_blank">
                                    <i class="fas fa-list me-1"></i> Final Packing List
                                </a>
                            </div>
                            @endif
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.footer')