@include('admin.header')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>Final Shipment Updates - {{ $shipment->shipment_number }}</h4>
                <div>
                    <a href="{{ route('admin.shipments.show', $shipment) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Back to Shipment
                    </a>
                    <a href="{{ route('admin.shipments.final-shipments.create', $shipment) }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i> Final Update
                    </a>
                </div>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Final Shipment Updates</h5>
                </div>
                <div class="card-body">
                    @if($finalShipments->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Final Shipment Date</th>
                                    <th>Original Qty</th>
                                    <th>Adjusted Qty</th>
                                    <th>Final Qty</th>
                                    <th>Adjustment Type</th>
                                    <th>Status</th>
                                    <th>Inspection Remarks</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($finalShipments as $final)
                                <tr>
                                    <td>{{ $final->final_shipment_date->format('M d, Y') }}</td>
                                    <td>{{ number_format($final->original_quantity) }}</td>
                                    <td class="{{ $final->adjusted_quantity >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ $final->adjusted_quantity >= 0 ? '+' : '' }}{{ number_format($final->adjusted_quantity) }}
                                    </td>
                                    <td class="fw-bold text-primary">{{ number_format($final->final_quantity) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $final->adjustment_type == 'positive' ? 'success' : 'danger' }}">
                                            {{ $final->adjustment_type == 'positive' ? 'Increase' : 'Decrease' }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $final->status_badge_color }}">
                                            {{ ucfirst($final->status) }}
                                        </span>
                                    </td>
                                    <td>{{ Str::limit($final->inspection_remarks, 30) }}</td>
                                    <td class="table-actions">
                                        <a href="{{ route('admin.shipments.final-shipments.show', [$shipment, $final]) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.shipments.final-shipments.edit', [$shipment, $final]) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.shipments.final-shipments.destroy', [$shipment, $final]) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="text-center text-muted py-4">
                        <i class="fas fa-ship fa-3x mb-3"></i>
                        <p>No final shipment updates yet.</p>
                        <a href="{{ route('admin.shipments.final-shipments.create', $shipment) }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Create First Update
                        </a>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Summary Cards -->
            @if($finalShipments->count() > 0)
            <div class="row mt-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <h6 class="card-title">Total Updates</h6>
                            <h3>{{ $finalShipments->count() }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <h6 class="card-title">Positive Adjustments</h6>
                            <h3>{{ $finalShipments->where('adjusted_quantity', '>', 0)->count() }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-dark">
                        <div class="card-body">
                            <h6 class="card-title">Negative Adjustments</h6>
                            <h3>{{ $finalShipments->where('adjusted_quantity', '<', 0)->count() }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <h6 class="card-title">Completed</h6>
                            <h3>{{ $finalShipments->where('status', 'completed')->count() }}</h3>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

@include('admin.footer')