<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Packing List - {{ $shipment->shipment_number }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #333; padding-bottom: 15px; }
        .company-name { font-size: 20px; font-weight: bold; }
        .packing-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .packing-table th, .packing-table td { padding: 8px; border: 1px solid #333; text-align: left; }
        .packing-table th { background: #333; color: white; }
        .summary { margin-top: 30px; padding: 15px; border: 1px solid #333; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">FINAL PACKING LIST</div>
        <div>Shipment: {{ $shipment->shipment_number }}</div>
    </div>

    <table class="packing-table">
        <thead>
            <tr>
                <th>Carton No</th>
                <th>Quantity</th>
                <th>Gross Weight (kg)</th>
                <th>Net Weight (kg)</th>
                <th>Volume (m³)</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            @foreach($shipment->cartonDetails as $carton)
            <tr>
                <td>{{ $carton->carton_number }}</td>
                <td>{{ number_format($carton->quantity) }}</td>
                <td>{{ $carton->gross_weight ? number_format($carton->gross_weight, 2) : 'N/A' }}</td>
                <td>{{ $carton->net_weight ? number_format($carton->net_weight, 2) : 'N/A' }}</td>
                <td>{{ $carton->volume ? number_format($carton->volume, 3) : 'N/A' }}</td>
                <td>{{ $carton->description }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="summary">
        <strong>Final Shipment Summary:</strong><br>
        Original Quantity: {{ number_format($finalShipment->original_quantity) }}<br>
        Adjusted Quantity: {{ $finalShipment->adjusted_quantity >= 0 ? '+' : '' }}{{ number_format($finalShipment->adjusted_quantity) }}<br>
        Final Quantity: {{ number_format($finalShipment->final_quantity) }}<br>
        Adjustment Reason: {{ $finalShipment->adjustment_reason }}
    </div>
</body>
</html>