<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Final Invoice - {{ $shipment->shipment_number }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
        .company-name { font-size: 24px; font-weight: bold; }
        .invoice-title { font-size: 20px; margin: 20px 0; }
        .details-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .details-table td { padding: 8px; border: 1px solid #ddd; }
        .details-table .label { font-weight: bold; background: #f8f9fa; }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">FINAL SHIPMENT INVOICE</div>
        <div>Shipment Completed</div>
    </div>

    <table class="details-table">
        <tr>
            <td class="label" width="25%">Shipment Number:</td>
            <td>{{ $shipment->shipment_number }}</td>
            <td class="label" width="25%">Order Number:</td>
            <td>{{ $shipment->orderConfirmation->order_number }}</td>
        </tr>
        <tr>
            <td class="label">Final Shipment Date:</td>
            <td>{{ $finalShipment->final_shipment_date->format('d/m/Y') }}</td>
            <td class="label">Status:</td>
            <td>{{ ucfirst($finalShipment->status) }}</td>
        </tr>
    </table>

    <div style="margin: 20px 0;">
        <h3>Quantity Summary</h3>
        <table class="details-table">
            <tr>
                <td class="label">Original Quantity:</td>
                <td>{{ number_format($finalShipment->original_quantity) }}</td>
            </tr>
            <tr>
                <td class="label">Adjusted Quantity:</td>
                <td>{{ $finalShipment->adjusted_quantity >= 0 ? '+' : '' }}{{ number_format($finalShipment->adjusted_quantity) }}</td>
            </tr>
            <tr style="font-weight: bold;">
                <td class="label">Final Quantity:</td>
                <td>{{ number_format($finalShipment->final_quantity) }}</td>
            </tr>
        </table>
    </div>

    @if($finalShipment->adjustment_reason)
    <div style="margin: 20px 0;">
        <strong>Adjustment Reason:</strong><br>
        {{ $finalShipment->adjustment_reason }}
    </div>
    @endif

    @if($finalShipment->inspection_remarks)
    <div style="margin: 20px 0;">
        <strong>Inspection Remarks:</strong><br>
        {{ $finalShipment->inspection_remarks }}
    </div>
    @endif
</body>
</html>